/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.fluid;

import com.neep.meatlib.fluid.BaseFluid;
import com.neep.neepmeat.init.NMParticles;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;

public abstract class PersistentFluid
extends BaseFluid {
    public static void incrementLevel(class_1937 world, class_2338 pos, class_2680 state, class_3609 fluid) {
        class_3610 fluidstate = world.method_8316(pos);
        if (!fluidstate.method_15769() && !fluidstate.method_15772().equals(fluid)) {
            return;
        }
        if (fluidstate.method_15769() && state.method_27852(class_2246.field_10124)) {
            world.method_8652(pos, fluid.method_15728(1, false).method_15759(), 3);
            return;
        }
        int level = fluidstate.method_15761();
        world.method_8652(pos, fluid.method_15728(level + 1, false).method_15759(), 3);
    }

    @Override
    protected int method_15733(class_4538 world) {
        return 10;
    }

    @Override
    public int method_15789(class_4538 world) {
        return 10;
    }

    @Override
    protected float method_15784() {
        return 100.0f;
    }

    public void method_15778(class_1937 world, class_2338 pos, class_3610 oldState) {
        class_3610 newState = this.updateFlow(world, pos, oldState);
        if (!oldState.method_15771()) {
            int i = this.method_15753(world, pos, oldState, newState);
            if (newState.method_15769()) {
                world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            } else if (!newState.equals(oldState)) {
                class_2680 blockState = newState.method_15759();
                world.method_8652(pos, blockState, 2);
                world.method_39281(pos, newState.method_15772(), i);
                world.method_8452(pos, blockState.method_26204());
            }
        }
    }

    protected class_3610 method_15727(class_1937 world, class_2338 pos, class_2680 state) {
        return state.method_26227();
    }

    protected class_3610 updateFlow(class_1937 world, class_2338 fluidPos, class_3610 state) {
        if (state.method_15769()) {
            return state;
        }
        int level = state.method_15761();
        class_2338 targetPos = fluidPos.method_10079(class_2350.field_11033, 1);
        class_2680 targetState = world.method_8320(targetPos);
        int targetLevel2 = targetState.method_26227().method_15761();
        if (this.canFill((class_1922)world, targetPos, targetState) && targetLevel2 < 8 && level > 0) {
            int toDown = Math.min(8 - targetLevel2, level);
            if (targetLevel2 + toDown > 0) {
                this.trySetBlockState(world, targetPos, this.method_15728(targetLevel2 + toDown, false).method_15759(), targetState);
            }
            level -= toDown;
        }
        ObjectArrayList posList = new ObjectArrayList();
        List directions = class_2350.class_2353.field_11062.method_43342(world.method_8409());
        if (level > 0) {
            ObjectBooleanPair pos;
            boolean canEmpty;
            for (class_2350 direction : directions) {
                int otherLevel;
                class_2338 adj = fluidPos.method_10093(direction);
                class_2338 adjDown = adj.method_10074();
                class_2680 adjState = world.method_8320(adj);
                class_2680 adjDownState = world.method_8320(adjDown);
                boolean canFillDown = this.canFill((class_1922)world, adjDown, adjDownState);
                if (!canFillDown) {
                    otherLevel = adjState.method_26227().method_15761();
                    if (!this.canFill((class_1922)world, adj, adjState) || otherLevel >= level || level <= 1) continue;
                    posList.add(ObjectBooleanPair.of((Object)adj, (boolean)false));
                    continue;
                }
                otherLevel = adjDownState.method_26227().method_15761();
                if (!this.canFill((class_1922)world, adjDown, adjDownState) || otherLevel >= 8) continue;
                posList.add(ObjectBooleanPair.of((Object)adjDown, (boolean)true));
            }
            Iterator targetLevel2 = posList.iterator();
            while (targetLevel2.hasNext() && level > ((canEmpty = (pos = (ObjectBooleanPair)targetLevel2.next()).secondBoolean()) ? 0 : 1)) {
                class_2680 targetState2 = world.method_8320((class_2338)pos.first());
                int targetLevel3 = targetState2.method_26227().method_15761();
                this.trySetBlockState(world, (class_2338)pos.first(), this.method_15728(targetLevel3 + 1, false).method_15759(), targetState2);
                --level;
            }
        }
        if (level != state.method_15761()) {
            class_2680 newState = level > 0 ? this.method_15728(level, false).method_15759() : class_2246.field_10124.method_9564();
            world.method_8652(fluidPos, newState, 3);
            return newState.method_26227();
        }
        return state;
    }

    private void trySetBlockState(class_1937 world, class_2338 pos, class_2680 state, class_2680 prevState) {
        if (prevState.method_26215() || prevState.method_27852(state.method_26204())) {
            world.method_8652(pos, state, 3);
        } else if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199((class_2394)new class_2388(NMParticles.FLUID_BITS, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    private boolean canFill(class_1922 world, class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2402) {
            return ((class_2402)block).method_10310(world, pos, state, (class_3611)this);
        }
        if (block instanceof class_2323 || state.method_26164(class_3481.field_15500) || state.method_27852(class_2246.field_9983) || state.method_27852(class_2246.field_10424) || state.method_27852(class_2246.field_10422)) {
            return false;
        }
        return !(state.method_27852(class_2246.field_10316) || state.method_27852(class_2246.field_10027) || state.method_27852(class_2246.field_10613) || state.method_27852(class_2246.field_10369)) ? !state.method_51366() : false;
    }

    public long getAmount(class_3610 fluidState) {
        return (long)fluidState.method_15761() * 81000L / 8L;
    }

    public FluidVariant getVariant(class_3610 fluidState) {
        return FluidVariant.of((class_3611)this);
    }

    public boolean extractOrNothing(class_1937 world, class_2338 pos, class_3610 fluidState, long amount) {
        int maxLevel;
        if (amount % 10125L != 0L) {
            return false;
        }
        int levels = Math.toIntExact(amount / 10125L);
        if (levels > (maxLevel = fluidState.method_15761())) {
            return false;
        }
        int newLevel = maxLevel - levels;
        class_2680 newState = newLevel == 0 ? class_2246.field_10124.method_9564() : this.method_15728(newLevel, false).method_15759();
        world.method_8501(pos, newState);
        return true;
    }
}

