/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.enlightenment;

import com.neep.neepmeat.api.enlightenment.EnlightenmentEvent;
import com.neep.neepmeat.client.hud.HUDOverlays;
import com.neep.neepmeat.enlightenment.EnlightenmentEventManager;
import com.neep.neepmeat.enlightenment.EnlightenmentManager;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.item.DosimeterItem;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class PlayerEnlightenmentManager
implements EnlightenmentManager,
ClientTickingComponent,
ServerTickingComponent,
AutoSyncedComponent {
    private final class_1657 player;
    private double acuteEnlightenment;
    private double chronicEnlightenment;
    public static final int FILTER_LENGTH = 4;
    private final ByteBuffer dosesBytes = ByteBuffer.allocate(32);
    private final DoubleBuffer doses = this.dosesBytes.asDoubleBuffer();
    private int current = 0;
    private double dose = 0.0;
    private final List<EnlightenmentEvent> events = new ObjectArrayList();
    public boolean randomClock;
    public boolean scareVillagers;
    public boolean objectAbove;
    private final class_5819 random = class_5819.method_43047();
    public static RespawnCopyStrategy<PlayerEnlightenmentManager> RESPAWN_STRATEGY = (from, to, lossless, keepInventory, sameCharacter) -> {
        RespawnCopyStrategy.copy((Component)from, (Component)to);
        to.acuteEnlightenment = 0.0;
    };

    public PlayerEnlightenmentManager(class_1657 player) {
        this.player = player;
    }

    @Override
    public int getTotal() {
        return (int)(this.acuteEnlightenment + this.chronicEnlightenment);
    }

    @Override
    public void exposeDose(float base, double sqDistance, double split) {
        double corrected = PlayerEnlightenmentManager.inverseSquare(base, sqDistance);
        this.acuteEnlightenment += (1.0 + corrected) * (1.0 - split);
        this.chronicEnlightenment += corrected * split;
        this.dose += corrected;
    }

    public static double inverseSquare(float base, double sqDistance) {
        if (sqDistance == 0.0) {
            return base;
        }
        return class_3532.method_15350((double)((double)(base * 1.0f) / sqDistance), (double)0.0, (double)base);
    }

    @Override
    public void addChronic(float amount) {
        this.chronicEnlightenment += (double)amount;
        this.dose += (double)amount;
    }

    @Override
    public double lastDose() {
        double value = 0.0;
        for (int i = 0; i < this.doses.capacity(); ++i) {
            value += this.doses.get(i);
        }
        return value;
    }

    @Override
    public double getAcute() {
        return this.acuteEnlightenment;
    }

    @Override
    public double getChronic() {
        return this.chronicEnlightenment;
    }

    @Override
    public void setAcute(double amount) {
        this.acuteEnlightenment = amount;
    }

    @Override
    public void setChronic(double amount) {
        this.chronicEnlightenment = amount;
    }

    public void serverTick() {
        this.acuteEnlightenment = Math.max(0.0, this.acuteEnlightenment - 1.0);
        this.chronicEnlightenment = Math.max(0.0, this.chronicEnlightenment - 1.0E-4);
        this.doses.put(this.current, this.dose);
        this.current = (this.current + 1) % this.doses.capacity();
        NMComponents.ENLIGHTENMENT_MANAGER.sync((Object)this.player);
        this.dose = 0.0;
        this.tickEvents();
    }

    public void addEvent(EnlightenmentEvent event) {
        this.events.add(event);
    }

    private void tickEvents() {
        Iterator<EnlightenmentEvent> it = this.events.iterator();
        while (it.hasNext()) {
            EnlightenmentEvent event = it.next();
            event.tick();
            if (!event.isRemoved()) continue;
            it.remove();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void clientTick() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == this.player) {
            if (this.lastDose() >= 0.3 && this.random.method_43057() < 0.5f && client.field_1724 == this.player) {
                HUDOverlays.startPylonVignette();
            }
            if (client.field_1687.method_8510() % 4L == 0L) {
                DosimeterItem.Client.onTick(client, (class_1657)client.field_1724, this);
            }
        }
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        this.acuteEnlightenment = tag.method_10574("acute");
        this.chronicEnlightenment = tag.method_10574("chronic");
        this.dose = tag.method_10574("dose");
        byte[] read = tag.method_10547("doses");
        if (read.length == this.dosesBytes.capacity()) {
            System.arraycopy(tag.method_10547("doses"), 0, this.dosesBytes.array(), 0, this.dosesBytes.capacity());
        }
        this.randomClock = tag.method_10577("randomClock");
        this.objectAbove = tag.method_10577("objectAbove");
        class_2499 eventsNbt = tag.method_10554("events", 10);
        class_1937 class_19372 = this.player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.events.clear();
            for (int i = 0; i < eventsNbt.size(); ++i) {
                class_2487 eventNbt = eventsNbt.method_10602(i);
                class_2960 id = class_2960.method_12829((String)eventNbt.method_10558("id"));
                EnlightenmentEvent.Factory type = (EnlightenmentEvent.Factory)EnlightenmentEventManager.EVENTS.method_10223(id);
                if (type == null) continue;
                this.events.add(type.create(serverWorld, (class_3222)this.player));
            }
        }
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        tag.method_10549("acute", this.acuteEnlightenment);
        tag.method_10549("chronic", this.chronicEnlightenment);
        tag.method_10549("dose", this.dose);
        tag.method_10570("doses", this.dosesBytes.array());
        tag.method_10556("randomClock", this.randomClock);
        tag.method_10556("objectAbove", this.objectAbove);
        if (this.player.method_37908() instanceof class_3218) {
            class_2499 eventsNbt = new class_2499();
            for (EnlightenmentEvent event : this.events) {
                EnlightenmentEvent.Factory type = event.getType();
                if (type == null) continue;
                class_2487 eventNbt = new class_2487();
                class_2960 id = EnlightenmentEventManager.EVENTS.method_10221((Object)type);
                eventNbt.method_10582("id", id.toString());
                eventsNbt.add((Object)eventNbt);
            }
            tag.method_10566("events", (class_2520)eventsNbt);
        }
    }

    public void sync() {
        NMComponents.ENLIGHTENMENT_MANAGER.sync((Object)this.player);
    }
}

