/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.recipe;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.api.processing.OreFatRegistry;
import com.neep.neepmeat.compat.emi.helper.EmiIngredientHelper;
import com.neep.neepmeat.init.NMBlocks;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class OreFatProcessingEmiRecipe
implements EmiRecipe {
    private final EmiRecipeCategory category;
    private final class_2960 id;
    private final OreFatRegistry.Entry entry;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final ItemVariant output;

    public static OreFatProcessingEmiRecipe ofItemVariants(EmiRecipeCategory category, Collection<ItemVariant> input, OreFatRegistry.Entry entry) {
        return new OreFatProcessingEmiRecipe(category, input.stream().map(EmiIngredientHelper::variantToIngredient).toList(), entry);
    }

    public static OreFatProcessingEmiRecipe ofItems(EmiRecipeCategory category, Collection<class_1792> input, OreFatRegistry.Entry entry) {
        return new OreFatProcessingEmiRecipe(category, input.stream().map(i -> EmiStack.of((class_1935)i)).toList(), entry);
    }

    public OreFatProcessingEmiRecipe(EmiRecipeCategory category, List<EmiIngredient> inputs, OreFatRegistry.Entry entry) {
        this.category = category;
        this.entry = entry;
        this.inputs = inputs;
        this.output = entry.result();
        this.outputs = List.of(EmiStack.of((class_1935)this.output.getItem(), (class_2487)this.output.getNbt()));
        this.id = new class_2960("neepmeat", "/" + this.output.getItem().method_40131().method_40237().method_29177().toString().replace(':', '_'));
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return 70;
    }

    public void addWidgets(WidgetHolder widgets) {
        int w = 140;
        int startX = (this.getDisplayWidth() - w) / 2;
        int startY = 7;
        int fatX = startX + 54;
        int pressX = fatX + 20;
        int outX = pressX + 26;
        int cleanY = startY + 40;
        widgets.addSlot(EmiIngredient.of(this.inputs), startX, startY);
        FluidVariant dirty = this.entry.getDirty();
        FluidVariant clean = this.entry.getClean();
        this.addArrow((class_1935)NMBlocks.CRUCIBLE, startX + 20, startY, widgets);
        widgets.addTexture(GUIUtil.WIDGETS, fatX, startY + 20, 18, 18, 0, 0, 18, 18, 128, 128);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)NMBlocks.SMALL_TROMMEL), fatX, startY + 20).drawBack(false);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_3611)dirty.getFluid(), (class_2487)dirty.getNbt()), fatX, startY);
        this.addArrow(NMBlocks.HYDRAULIC_PRESS, pressX, startY, widgets);
        this.addOutputs((EmiIngredient)this.outputs.get(0), this.entry.renderingYield(), outX, startY, widgets);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_3611)clean.getFluid(), (class_2487)clean.getNbt()), fatX, cleanY);
        this.addArrow(NMBlocks.HYDRAULIC_PRESS, pressX, cleanY, widgets);
        this.addOutputs((EmiIngredient)this.outputs.get(0), this.entry.renderingYield() * this.entry.trommelYield(), outX, cleanY, widgets);
    }

    private void addArrow(class_1935 process, int x, int y, WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, x, y);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)process), x + 3, y).drawBack(false);
    }

    private void addOutputs(EmiIngredient ingredient, float yield, int x, int y, WidgetHolder widgets) {
        long base = (long)Math.floor(yield);
        float extra = yield - (float)base;
        widgets.addSlot(ingredient.copy().setAmount(base), x, y).recipeContext((EmiRecipe)this);
        if (extra > 0.0f) {
            widgets.addSlot(ingredient.copy().setChance(extra), x + 20, y).recipeContext((EmiRecipe)this);
        }
    }
}

