/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.recipe;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.compat.emi.NMEmiPlugin;
import com.neep.neepmeat.compat.emi.helper.EmiIngredientHelper;
import com.neep.neepmeat.machine.mixer.MixingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class MixingEmiRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final int processTime;

    public MixingEmiRecipe(MixingRecipe recipe) {
        this.processTime = recipe.getProcessTime();
        this.id = recipe.method_8114();
        this.input = List.of(EmiIngredientHelper.inputToIngredient(recipe.getFluidInputs().get(0)), EmiIngredientHelper.inputToIngredient(recipe.getFluidInputs().get(1)), EmiIngredientHelper.inputToIngredient(recipe.getItemIngredient()));
        this.output = List.of(EmiStack.of((class_3611)recipe.getFluidOutput().resource(), (long)recipe.getFluidOutput().minAmount()));
    }

    public EmiRecipeCategory getCategory() {
        return NMEmiPlugin.MIXING;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 150;
    }

    public int getDisplayHeight() {
        return 55;
    }

    public void addWidgets(WidgetHolder widgets) {
        int startX = this.getDisplayWidth() / 2 - 41;
        int startY = 15;
        widgets.addText((class_2561)NeepMeat.translationKey("category", "general.energy", PowerUtils.formatEnergy((long)this.processTime * PowerUtils.BASE_POWER, 2)), this.getDisplayWidth() - 5, 3, -12566464, false).horizontalAlign(TextWidget.Alignment.END);
        widgets.addFillingArrow(startX + 24, startY + 9, this.processTime * 1000 / 20);
        if (!this.input.get(1).isEmpty()) {
            widgets.addSlot(this.input.get(0), startX + 1, startY - 1);
            widgets.addSlot(this.input.get(1), startX + 1, startY + 19);
        } else {
            widgets.addSlot(this.input.get(0), startX + 1, startY + 9);
        }
        if (this.input.get(2).getAmount() != 0L) {
            widgets.addSlot(this.input.get(2), startX - 20, startY + 9);
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), startX + 61, startY + 9).recipeContext((EmiRecipe)this);
    }
}

