/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.recipe;

import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.processing.BlockCrushingRegistry;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.compat.emi.helper.EmiIngredientHelper;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.recipe.BlockCrushingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class BlockCrushingEmiRecipe
implements EmiRecipe {
    private final EmiRecipeCategory category;
    private final class_2960 id;
    private final EmiIngredient input;
    private final RecipeOutput<?> recipeOutput;
    private final EmiStack output;
    private final EmiStack extraOutput;
    private final int processTime;

    public BlockCrushingEmiRecipe(int index, EmiRecipeCategory category, BlockCrushingRecipe recipe, BlockCrushingRegistry.Entry entry) {
        this.category = category;
        this.id = new class_2960(recipe.method_8114().method_12836(), "/" + recipe.method_8114().method_12832() + "_" + index);
        this.processTime = recipe.getTime();
        this.input = EmiIngredientHelper.inputToIngredient(entry.input());
        this.recipeOutput = entry.output();
        this.output = EmiIngredientHelper.outputToStack(entry.output());
        this.extraOutput = EmiIngredientHelper.outputToStack(entry.extra()).setChance(entry.extra().chance());
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output, this.extraOutput);
    }

    public int getDisplayWidth() {
        return 150;
    }

    public int getDisplayHeight() {
        return 55;
    }

    public void addWidgets(WidgetHolder widgets) {
        int startX = this.getDisplayWidth() / 2 - 41;
        int startY = 10;
        widgets.addText((class_2561)NeepMeat.translationKey("category", "general.energy", PowerUtils.energyForRecipe(this.processTime)), this.getDisplayWidth() - 5, 3, -12566464, false).horizontalAlign(TextWidget.Alignment.END);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, startX + 25, startY + 9);
        widgets.addSlot(this.getInputs().get(0), startX + 1, startY + 9);
        if (!this.output.isEmpty()) {
            long amount = this.output.getAmount();
            widgets.addSlot(EmiIngredient.of(List.of(this.output), (long)amount), startX + 61, startY + 9).recipeContext((EmiRecipe)this).appendTooltip(NMrecipeTypes.ofMinMax(this.recipeOutput.minAmount(), this.recipeOutput.maxAmount()));
            widgets.addSlot(EmiIngredient.of(List.of(this.extraOutput)), startX + 81, startY + 9).recipeContext((EmiRecipe)this);
        }
    }
}

