/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.recipe;

import com.neep.neepmeat.compat.emi.NMEmiPlugin;
import com.neep.neepmeat.compat.emi.helper.EmiIngredientHelper;
import com.neep.neepmeat.recipe.BioreactorRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class BioreactorEmiRecipe
implements EmiRecipe {
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final float processTime;
    private final class_2960 id;

    public BioreactorEmiRecipe(BioreactorRecipe recipe) {
        this.id = recipe.method_8114();
        this.processTime = recipe.getProcessTime();
        this.inputs = Stream.concat(recipe.getItemInputs().stream(), recipe.getFluidInputs().stream()).map(EmiIngredientHelper::inputToIngredient).toList();
        this.outputs = List.of(EmiStack.of((class_3611)recipe.getOutputs().resource(), (long)recipe.getOutputs().minAmount()));
    }

    public EmiRecipeCategory getCategory() {
        return NMEmiPlugin.BIOREACTOR;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 150;
    }

    public int getDisplayHeight() {
        return Math.max(55, 20 + this.inputs.size() / 3 * 18);
    }

    public void addWidgets(WidgetHolder widgets) {
        int ny = class_3532.method_15386((float)((float)this.inputs.size() / 3.0f));
        int startX = this.getDisplayWidth() / 2 - 60;
        int startY = (this.getDisplayHeight() - ny * 18) / 2 + 5;
        int outputY = (this.getDisplayHeight() - 18) / 2;
        for (int j = 0; j < ny; ++j) {
            for (int i = 0; i < 3; ++i) {
                int idx = j * 3 + i;
                if (idx < this.inputs.size()) {
                    EmiIngredient ingredient = this.inputs.get(idx);
                    widgets.addSlot(ingredient, startX + i * 18, startY + j * 18);
                    continue;
                }
                widgets.addSlot(startX + i * 18, startY + j * 18);
            }
        }
        DecimalFormat df = new DecimalFormat("###.##");
        widgets.addText((class_2561)class_2561.method_43469((String)"category.neepmeat.mixing.time", (Object[])new Object[]{df.format((double)this.processTime / 20.0)}), this.getDisplayWidth() - 5, 5, -12566464, false).horizontalAlign(TextWidget.Alignment.END);
        widgets.addFillingArrow(startX + 54 + 5, this.getDisplayHeight() / 2 - 8, (int)(this.processTime * 1000.0f / 20.0f));
        widgets.addSlot((EmiIngredient)this.outputs.get(0), startX + 91, outputY).recipeContext((EmiRecipe)this);
    }
}

