/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.recipe;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.api.processing.ball_mill.BallMillRecipe;
import com.neep.neepmeat.compat.emi.NMEmiPlugin;
import com.neep.neepmeat.compat.emi.helper.EmiIngredientHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class BallMillEmiRecipe
implements EmiRecipe {
    private final EmiIngredient input;
    private final List<EmiStack> outputs;
    private final float processTime;
    private final class_2960 id;

    public BallMillEmiRecipe(BallMillRecipe recipe) {
        this.id = recipe.method_8114();
        this.processTime = recipe.getTime();
        this.input = EmiIngredientHelper.inputToIngredient(recipe.getInput());
        this.outputs = recipe.getOutputs().stream().map(EmiIngredientHelper::outputToStack).toList();
    }

    public EmiRecipeCategory getCategory() {
        return NMEmiPlugin.BALL_MILL;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 150;
    }

    public int getDisplayHeight() {
        return Math.max(55, 20 + this.outputs.size() / 3 * 18);
    }

    public void addWidgets(WidgetHolder widgets) {
        int ny = class_3532.method_15386((float)((float)this.outputs.size() / 3.0f));
        int startX = this.getDisplayWidth() / 2 - 60;
        int startY = (this.getDisplayHeight() - 18) / 2;
        widgets.addText((class_2561)NeepMeat.translationKey("category", "general.energy", PowerUtils.energyForRecipe(this.processTime)), this.getDisplayWidth() - 5, 3, -12566464, false).horizontalAlign(TextWidget.Alignment.END);
        widgets.addSlot(this.input, startX, startY);
        widgets.addFillingArrow(startX + 18 + 5, this.getDisplayHeight() / 2 - 8, (int)(this.processTime * 1000.0f / 20.0f));
        int outputX = startX + 51;
        int outputY = (this.getDisplayHeight() - ny * 18) / 2;
        for (int j = 0; j < ny; ++j) {
            for (int i = 0; i < 3; ++i) {
                int idx = j * 3 + i;
                if (idx < this.outputs.size()) {
                    EmiIngredient ingredient = (EmiIngredient)this.outputs.get(idx);
                    widgets.addSlot(ingredient, outputX + i * 18, outputY + j * 18).recipeContext((EmiRecipe)this);
                    continue;
                }
                widgets.addSlot(outputX + i * 18, outputY + j * 18).recipeContext((EmiRecipe)this);
            }
        }
    }
}

