/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.helper;

import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.neepmeat.init.NMrecipeTypes;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_3611;

public class EmiIngredientHelper {
    public static final EmiIngredient EMPTY = EmiIngredient.of((class_1856)class_1856.field_9017);
    public static final List<EmiIngredient> EMPTY_LIST = List.of(EMPTY);

    public static EmiIngredient inputToIngredient(RegistryRecipeInput<?> input) {
        if (input.isEmpty()) {
            return EMPTY;
        }
        long amount = input.amount();
        class_2487 nbt = input.nbtMatcher().getNbt();
        if (Ingredients.ITEM.equals(input.getType())) {
            List items = (List)input.getAll();
            if (items.isEmpty()) {
                return EMPTY;
            }
            return EmiIngredient.of(items.stream().map(item -> EmiStack.of((class_1935)item, (class_2487)nbt, (long)amount)).toList(), (long)amount);
        }
        if (Ingredients.FLUID.equals(input.getType())) {
            List fluids = (List)input.getAll();
            if (fluids.isEmpty()) {
                return EMPTY;
            }
            return EmiIngredient.of(fluids.stream().map(fluid -> EmiStack.of((class_3611)fluid, (class_2487)nbt, (long)input.amount())).toList(), (long)amount);
        }
        return EmiIngredient.of(List.of());
    }

    public static EmiStack outputToStack(RecipeOutput<class_1792> output) {
        EmiStack emiStack = EmiStack.of((class_1935)((class_1935)output.resource()), (class_2487)output.getNbt());
        emiStack.setAmount(output.minAmount());
        emiStack.getTooltipText().add(NMrecipeTypes.ofMinMax(output.minAmount(), output.maxAmount()));
        if (output.chance() != 1.0f) {
            emiStack.setChance(output.chance());
        }
        return emiStack;
    }

    public static EmiStack outputFluidToStack(RecipeOutput<class_3611> output) {
        EmiStack emiStack = EmiStack.of((class_3611)output.resource(), (class_2487)output.getNbt());
        emiStack.setAmount(output.minAmount());
        emiStack.getTooltipText().add(NMrecipeTypes.ofMinMax(output.minAmount(), output.maxAmount()));
        if (output.chance() != 1.0f) {
            emiStack.setChance(output.chance());
        }
        return emiStack;
    }

    public static EmiIngredient variantToIngredient(ItemVariant variant) {
        return EmiStack.of((class_1935)variant.getItem(), (class_2487)variant.getNbt());
    }
}

