/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.sound;

import com.neep.neepbus.block.entity.MouthBlockEntity;
import com.neep.neepspeak.NEEPSpeak;
import com.neep.neepspeak.NEEPSpeakException;
import com.neep.neepspeak.PhonemeList;
import com.neep.neepspeak.mouth.Mouth;
import com.neep.neepspeak.parser.RuleParser;
import com.neep.neepspeak.phoneme.PhonemeSet;
import com.neep.neepspeak.util.SampleBuffer;
import com.neep.neepspeak.util.SampleInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4234;
import org.lwjgl.BufferUtils;

@Environment(value=EnvType.CLIENT)
public class NEEPSpeakAudioStream
implements class_4234 {
    public static final AudioFormat FORMAT = NEEPSpeak.initOutputFormat((float)44100.0f, (int)2);
    private final Mouth mouth;

    public NEEPSpeakAudioStream(PhonemeList phonemeList) {
        this.mouth = new Mouth(phonemeList);
    }

    public NEEPSpeakAudioStream(String text, boolean phonetic) throws NEEPSpeakException {
        this(phonetic ? new PhonemeList(RuleParser.parseSamPhonetic((String)text, (PhonemeSet)PhonemeSet.NORMAL)) : MouthBlockEntity.PHONEMISER.process(text));
    }

    public AudioFormat method_19719() {
        return FORMAT;
    }

    public ByteBuffer method_19720(int size) throws IOException {
        if (this.mouth.isDone()) {
            return null;
        }
        int bytes = FORMAT.getSampleSizeInBits() / 8;
        int samples = size / bytes;
        SampleBuffer sb = new SampleBuffer(samples);
        this.mouth.init(new SampleInfo(FORMAT.getSampleRate(), samples));
        this.mouth.processBuffer(sb);
        ByteBuffer result = NEEPSpeak.floatsToOutput((float[])sb.data, (int)bytes, (boolean)FORMAT.isBigEndian(), BufferUtils::createByteBuffer);
        result.rewind();
        return result;
    }

    public void close() throws IOException {
    }

    public boolean isDone() {
        return this.mouth.isDone();
    }
}

