/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.tablet;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.client.screen.tablet.ContentPane;
import com.neep.neepmeat.client.screen.tablet.GuideScreen;
import com.neep.neepmeat.client.screen.tablet.GuideSearchWidget;
import com.neep.neepmeat.guide.GuideNode;
import com.neep.neepmeat.guide.GuideReloadListener;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.util.NMMaths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_763;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class GuideListPane
extends ContentPane
implements class_4068,
class_364,
class_6379 {
    protected final List<EntryWidget> entries = new ArrayList<EntryWidget>();
    private GuideNode lastNode;
    private int selected;
    protected int entryHeight = 11;
    protected int contentHeight;
    private int animationTicks;
    private boolean searchMode;
    private final GuideSearchWidget searchString;
    private int entryAnimationStart;

    public GuideListPane(GuideScreen parent) {
        super(class_2561.method_30163((String)"eeeee"), parent);
        this.field_22793 = class_310.method_1551().field_1772;
        this.searchString = new GuideSearchWidget("/", () -> this.searchMode, this.field_22793);
    }

    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        if (this.parent.getAnimationTicks() < 12) {
            return;
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        GUIUtil.renderBorder(matrices, this.x, this.y, this.field_22789, this.field_22790, -7829504, 0);
        if (this.selected != -1) {
            GUIUtil.renderBorder(matrices, this.x + this.screenOffsetX, this.y + this.screenOffsetY + this.selected * this.entryHeight, this.field_22789 - 2 * this.screenOffsetX, this.entryHeight, -5592576, 0);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchMode) {
            if (keyCode == 256) {
                this.searchString.clear();
                this.searchMode = false;
                this.method_25426();
                return true;
            }
            if (keyCode == 258) {
                this.setSelected(this.getSelected() + (modifiers == 1 ? -1 : 1));
            } else if (keyCode == 259) {
                this.searchString.erase(-1);
                this.method_25426();
            }
            super.method_25404(keyCode, scanCode, modifiers);
            return true;
        }
        if (keyCode == 47) {
            super.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (chr != '\u0100') {
            if (this.searchMode) {
                this.searchString.write(chr, modifiers);
                this.method_25426();
                return true;
            }
            if (chr == '/') {
                this.searchMode = true;
                this.method_25426();
            }
        }
        return super.method_25400(chr, modifiers);
    }

    @Override
    public void method_25393() {
        ++this.animationTicks;
        super.method_25393();
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.contentHeight = this.field_22790 - this.screenOffsetY - this.entryHeight;
        this.method_37067();
        if (!this.searchMode) {
            this.generateMenu();
        } else {
            this.updateSearch();
        }
        this.method_37063(this.searchString);
        this.searchString.setDims(this.x, this.y + this.field_22790 - this.entryHeight, this.field_22789, this.entryHeight);
        if (this.lastNode != this.parent.getPath().peek()) {
            this.entryAnimationStart = this.parent.getAnimationTicks();
            this.selected = -1;
            this.lastNode = this.parent.getPath().peek();
        }
    }

    protected void updateSearch() {
        this.entries.clear();
        Iterator filtered = GuideReloadListener.getInstance().getArticleNodes().stream().distinct().filter(a -> a.getText().toString().toLowerCase(Locale.ROOT).contains(this.searchString.string)).iterator();
        int i = 0;
        while (filtered.hasNext() && (i + 1) * this.entryHeight < this.contentHeight) {
            GuideNode node = (GuideNode)filtered.next();
            class_1799 icon = new class_1799((class_1935)class_7923.field_41178.method_10223(node.getIcon()));
            this.entries.add(new EntryWidget(i, this.screenOffsetX + this.x, this.screenOffsetY + this.y + i * this.entryHeight, this.field_22789 - 2 * this.screenOffsetX, this.entryHeight, icon, node.getText(), node));
            ++i;
        }
        this.entries.forEach(x$0 -> {
            EntryWidget cfr_ignored_0 = (EntryWidget)this.method_37063((class_364)x$0);
        });
    }

    protected void generateMenu() {
        this.entries.clear();
        this.entries.add(new EntryWidget(0, this.screenOffsetX + this.x, this.screenOffsetY + this.y, this.field_22789 - 2 * this.screenOffsetX, this.entryHeight, class_1799.field_8037, class_2561.method_30163((String)"\u2190"), GuideNode.BACK));
        List<GuideNode> nodes = this.parent.getPath().peek().getChildren();
        for (int i = 0; i < nodes.size(); ++i) {
            GuideNode node = nodes.get(i);
            class_1799 icon = new class_1799((class_1935)class_7923.field_41178.method_10223(node.getIcon()));
            this.entries.add(new EntryWidget(i + 1, this.screenOffsetX + this.x, this.screenOffsetY + this.y + (i + 1) * this.entryHeight, this.field_22789 - 2 * this.screenOffsetX, this.entryHeight, icon, node.getText(), node));
        }
        this.entries.forEach(x$0 -> {
            EntryWidget cfr_ignored_0 = (EntryWidget)this.method_37063((class_364)x$0);
        });
    }

    public void setSelected(int sel) {
        this.selected = NMMaths.wrap(sel, 0, this.entries.size() - 1);
        this.entries.get(this.selected).onPress();
    }

    public int getSelected() {
        return this.selected;
    }

    public void method_37020(class_6382 builder) {
    }

    @Override
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX > (double)this.x && mouseX < (double)(this.x + this.field_22789) && mouseY > (double)this.y && mouseY < (double)(this.y + this.field_22790);
    }

    public static void renderItemIcon(int x, int y, class_918 renderer, int zOffset, class_1799 stack, class_332 context, class_4597 vertexConsumers, int light, int overlay) {
        class_4587 matrices = context.method_51448();
        if (stack.method_7960()) {
            return;
        }
        class_763 models = renderer.method_4012();
        class_1087 bakedModel = models.method_3308(stack);
        class_1060 textureManager = class_310.method_1551().method_1531();
        textureManager.method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_46416((float)x, (float)y, 100.0f + (float)zOffset);
        matrixStack.method_22904(8.0, 7.0, 0.0);
        matrixStack.method_22905(1.0f, -1.0f, 1.0f);
        matrixStack.method_22905(10.0f, 10.0f, 10.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        GuideListPane.renderItem(stack, matrices, vertexConsumers, light, overlay, bakedModel);
        immediate.method_22993();
        RenderSystem.enableDepthTest();
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderItem(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1087 model) {
        class_811 renderMode = class_811.field_4317;
        matrices.method_22903();
        model.method_4709().method_3503(renderMode).method_23075(false, matrices);
        matrices.method_22904(-0.5, -0.5, -0.5);
        class_1921 renderLayer = class_4696.method_23678((class_1799)stack, (boolean)true);
        class_4588 vertexConsumer = class_918.method_29711((class_4597)vertexConsumers, (class_1921)renderLayer, (boolean)true, (boolean)stack.method_7958());
        GuideListPane.renderBakedItemModel(model, stack, light, overlay, matrices, vertexConsumer);
        matrices.method_22909();
    }

    private static void renderBakedItemModel(class_1087 model, class_1799 stack, int light, int overlay, class_4587 matrices, class_4588 vertices) {
        class_5819 random = class_5819.method_43047();
        for (class_2350 direction : class_2350.values()) {
            random.method_43052(42L);
            GuideListPane.renderGreenQuads(matrices, vertices, model.method_4707(null, direction, random), stack, light, overlay);
        }
        random.method_43052(42L);
        GuideListPane.renderGreenQuads(matrices, vertices, model.method_4707(null, null, random), stack, light, overlay);
    }

    private static void renderGreenQuads(class_4587 matrices, class_4588 vertices, List<class_777> quads, class_1799 stack, int light, int overlay) {
        class_4587.class_4665 entry = matrices.method_23760();
        for (class_777 bakedQuad : quads) {
            int i = 0xFFFFFF;
            float r = (float)(i >> 16 & 0xFF) / 255.0f;
            float g = (float)(i >> 8 & 0xFF) / 255.0f;
            float b = (float)(i & 0xFF) / 255.0f;
            vertices.method_22919(entry, bakedQuad, r, g, b, 0xF000F0, class_4608.field_21444);
        }
    }

    public class EntryWidget
    extends class_339 {
        private final GuideNode node;
        private final class_1799 icon;
        private final int index;

        public EntryWidget(int index, int x, int y, int w, int h, class_1799 icon, class_2561 text, GuideNode node) {
            super(x, y, w, h, text);
            this.index = index;
            this.node = node;
            this.icon = icon;
        }

        public void method_25354(class_1144 soundManager) {
            soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)NMSounds.MARATHON_BEEP, (float)1.0f));
        }

        protected void method_47399(class_6382 builder) {
        }

        public void method_25348(double mouseX, double mouseY) {
            this.onPress();
        }

        protected void onPress() {
            GuideListPane.this.selected = this.index;
            this.node.visitScreen(GuideListPane.this.parent);
        }

        public void method_48579(class_332 matrices, int mouseX, int mouseY, float delta) {
            if (GuideListPane.this.parent.getAnimationTicks() < (GuideListPane.this.animationTicks <= 32 ? 16 : 0) + GuideListPane.this.entryAnimationStart + this.index) {
                return;
            }
            class_4597.class_4598 vertexConsumers = class_310.method_1551().method_22940().method_23000();
            int borderCol = -16742400;
            int x = this.method_46426();
            int y = this.method_46427();
            GUIUtil.drawHorizontalLine1(matrices, x, x + this.field_22758, y + this.field_22759, borderCol);
            GUIUtil.drawHorizontalLine1(matrices, x, x + this.field_22758, y, borderCol);
            GUIUtil.drawVerticalLine1(matrices, x, y, y + this.field_22759, borderCol);
            GUIUtil.drawVerticalLine1(matrices, this.method_46426() + this.field_22758, this.method_46427(), this.method_46427() + this.field_22759, borderCol);
            GUIUtil.drawText(matrices, GuideListPane.this.field_22793, this.method_25369(), (float)(this.method_46426() + 2), (float)this.method_46427() + (float)(this.field_22759 - 7) / 2.0f, 34816, true);
            if (this.node.getChildren().size() > 0) {
                GUIUtil.drawText(matrices, GuideListPane.this.field_22793, "\u2192", (float)(this.method_46426() + this.field_22758 - 9), (float)this.method_46427() + (float)(this.field_22759 - 7) / 2.0f, 34816, true);
            } else {
                GuideListPane.renderItemIcon(this.method_46426() + this.field_22758 - 16, this.method_46427() - 1, GuideListPane.this.field_22787.method_1480(), 0, this.icon, matrices, (class_4597)vertexConsumers, 15, 0);
            }
        }
    }
}

