/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.plc;

import com.neep.neepmeat.client.screen.ScreenSubElement;
import com.neep.neepmeat.client.screen.plc.LanguageMode;
import com.neep.neepmeat.client.screen.plc.PLCProgramScreen;
import com.neep.neepmeat.client.screen.plc.PLCScreenState;
import com.neep.neepmeat.client.screen.plc.PLCStackViewer;
import com.neep.neepmeat.client.screen.plc.edit.EditBoxWidget;
import com.neep.neepmeat.client.screen.plc.edit.InstructionBrowserWidget;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.network.plc.PLCSyncAction;
import com.neep.neepmeat.plc.compiler.PLCCompilePipeline;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.screen.PLCScreenHandler;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class PLCScreenEditorState
extends ScreenSubElement
implements class_4068,
class_364,
class_6379,
PLCScreenState {
    private final PLCProgramScreen parent;
    private EditBoxWidget editorField;
    private final InstructionBrowserWidget browser;
    private final PLCStackViewer viewer;
    private boolean changed;
    @Nullable
    private PLCCompilePipeline pipeline = null;

    public PLCScreenEditorState(PLCProgramScreen parent) {
        this.parent = parent;
        this.browser = new InstructionBrowserWidget(() -> null, p -> true, this::selectProvider);
        this.viewer = new PLCStackViewer(parent.getScreenHandler().getPlc());
    }

    private void selectProvider(InstructionProvider provider) {
        this.editorField.insert(provider.getParseName().toLowerCase(Locale.ROOT));
    }

    @Override
    protected void init() {
        if (this.editorField == null) {
            this.editorField = new EditBoxWidget(this.x, this.y, 300, this.screenHeight, 0.8f, class_2561.method_30163((String)"Write your program here.\n\nClick a block in the world to insert its coordinates as a target.\n\nTo run the program, press the 'compile' button and then the 'run' button\n\nShortcuts:\nCTRL+S: Compile\nCTRL+R: Run/Pause\nCTRL+T: Stop\nCTRL+E: Compile and run.\nCTRL+F: Step")){

                public void method_25365(boolean focused) {
                    super.method_25365(focused);
                    PLCScreenEditorState.this.updateEditorWidth();
                }
            };
            this.editorField.setText(this.parent.getScreenHandler().getInitialText());
            this.editorField.setChangeListener(s -> {
                this.changed = true;
            });
        }
        this.updateEditorWidth();
        this.browser.init(this.screenWidth, this.screenHeight);
        this.viewer.init(this.screenWidth - 100 - 40, this.browser.getY(), 40, this.screenHeight - this.browser.getY());
        this.addDrawableChild(this.editorField);
        this.addDrawableChild(this.browser);
        this.addDrawable(this.viewer);
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        this.updateEditorWidth();
    }

    private void updateEditorWidth() {
        if (this.editorField.method_25370()) {
            this.editorField.method_25358(300);
        } else {
            this.editorField.method_25358(100);
        }
        this.editorField.setHeight(this.screenHeight);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.editorField != null) {
            if (this.client.field_1687.method_8510() % 10L == 0L && this.changed) {
                String text = this.editorField.getText();
                if (this.pipeline == null) {
                    this.pipeline = (PLCCompilePipeline)this.parent.getScreenHandler().getLanguage().apply(() -> null);
                }
                try {
                    if (text.length() >= Short.MAX_VALUE) {
                        throw new NeepASM.ProgramBuildException(-1, 0, "text too long (> 32767 chars)");
                    }
                    this.pipeline.parse(text);
                    this.setCompileMessage("Parsed Successfully", true, -1);
                }
                catch (NeepASM.ProgramBuildException e) {
                    this.setCompileMessage(e.getMessage(), false, e.line());
                }
                if (text.length() < Short.MAX_VALUE) {
                    this.parent.getScreenHandler().updateText.emitter().accept(text);
                }
                this.changed = false;
            }
            this.editorField.setDebugLine(this.parent.getScreenHandler().debugLine());
        }
    }

    public void setCompileMessage(String message, boolean success, int line) {
        this.editorField.setError(message, success ? -12277248 : -65536);
        this.editorField.setErrorLine(line);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.editorField.method_49606() && this.method_25399() == this.editorField) {
            this.method_25395(null);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25400(char chr, int modifiers) {
        return super.method_25400(chr, modifiers);
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33786;
    }

    @Override
    public boolean isSelected() {
        return true;
    }

    @Override
    public void argument(Argument argument) {
        this.editorField.insert("@(" + argument.pos().method_10263() + " " + argument.pos().method_10264() + " " + argument.pos().method_10260() + " " + argument.face().name().toUpperCase().charAt(0) + ")");
    }

    @Override
    public void onKeyPressed(int keyCode, int scanCode, int modifiers) {
        this.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_437.method_25441()) {
            PLCScreenHandler handler = this.parent.getScreenHandler();
            if (keyCode == 82) {
                if (handler.isRunning()) {
                    handler.channel.emitter().apply(PLCSyncAction.PAUSE);
                } else {
                    handler.channel.emitter().apply(PLCSyncAction.RUN);
                }
                return true;
            }
            if (keyCode == 83) {
                handler.channel.emitter().apply(PLCSyncAction.COMPILE);
            } else if (keyCode == 70) {
                handler.channel.emitter().apply(PLCSyncAction.STEP);
            } else if (keyCode == 69) {
                handler.channel.emitter().apply(PLCSyncAction.COMPILE_RUN);
            } else if (keyCode == 84) {
                handler.channel.emitter().apply(PLCSyncAction.STOP);
                return true;
            }
        }
        if (keyCode == 258 && !this.isSelected()) {
            return false;
        }
        return this.method_25399() != null && this.method_25399().method_25404(keyCode, scanCode, modifiers);
    }

    public boolean isEditFieldFocused() {
        return this.editorField.method_25370();
    }

    public void changeLanguage(LanguageMode language) {
        this.pipeline = (PLCCompilePipeline)language.apply(() -> null);
        this.changed = true;
    }
}

