/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.living_machine.widget;

import com.neep.meatlib.client.screen.TooltipHelper;
import com.neep.meatlib.client.screen.auto.SimplePanel;
import com.neep.meatlib.client.screen.auto.SplitPanel;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.ClickableWidget;
import com.neep.meatlib.client.screen.widget.SolidColProgressBar;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.screen_handler.widget.DistributorCooldownWidgetHandler;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class DistributorCooldownWidget
extends SimplePanel
implements Rectangle.Mutable {
    private final DistributorCooldownWidgetHandler handler;
    private final SolidColProgressBar cooldownBar;
    private int cooldown;
    private int maxCooldown;
    private boolean powered;

    public DistributorCooldownWidget(class_327 textRenderer, DistributorCooldownWidgetHandler handler) {
        this.handler = handler;
        handler.syncCooldownS2C.receiver(this::receiveCooldown);
        this.cooldownBar = new SolidColProgressBar(SplitPanel.Split.HORIZONTAL, textRenderer, PLCCols.BORDER.col, () -> this.maxCooldown == 0 ? 0.0f : (float)this.cooldown / (float)this.maxCooldown, () -> class_2561.method_30163((String)this.text()));
        this.solidW();
        this.solidH();
    }

    private String text() {
        if (!this.powered) {
            return "INVALID MACHINE";
        }
        if (this.cooldown <= 0) {
            return "READY";
        }
        return "";
    }

    @Override
    public void renderTooltipLayer(class_332 context, int mouseX, int mouseY, float delta) {
        super.renderTooltipLayer(context, mouseX, mouseY, delta);
        if (this.isWithin(mouseX, mouseY) && !this.powered) {
            TooltipHelper.get().draw(context, mouseX, mouseY, List.of(class_2561.method_30163((String)"Add a machine controller and item/fluid ports.")));
        }
    }

    private void receiveCooldown(int cooldown, int maxCooldown, boolean powered) {
        this.cooldown = cooldown;
        this.maxCooldown = maxCooldown;
        this.powered = powered;
    }

    @Override
    protected ClickableWidget initMainElement() {
        DistributorCooldownWidget.setDims(this.cooldownBar, this.x, this.y, this.w, this.h);
        return this.cooldownBar;
    }
}

