/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.network.MachineDiagnosticsRequest;
import java.awt.Color;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_5348;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class MachineHudOverlay {
    static MachineHudOverlay INSTANCE = new MachineHudOverlay();
    protected MotorisedBlock.Diagnostics diagnostics = null;
    protected int updateInterval = 10;
    protected int updateCounter = 0;

    public static MachineHudOverlay getInstance() {
        return INSTANCE;
    }

    public MachineHudOverlay() {
        HudRenderCallback.EVENT.register((matrixStack, tickDelta) -> {
            MachineHudOverlay.getInstance().update(class_310.method_1551(), class_310.method_1551().field_1687);
            MachineHudOverlay.getInstance().onRender(class_310.method_1551(), matrixStack, tickDelta);
        });
    }

    public void receive(MotorisedBlock.Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }

    public void update(class_310 client, class_638 world) {
        class_239 class_2393;
        this.updateCounter = Math.min(this.updateInterval, this.updateCounter + 1);
        if (world == null || client.field_1724 == null || this.updateCounter < this.updateInterval) {
            return;
        }
        this.updateCounter = 0;
        if (client.field_1765 != null && (class_2393 = client.field_1765) instanceof class_3965) {
            class_3965 result = (class_3965)class_2393;
            class_2338 pos = result.method_17777();
            if (world.method_8321(pos) instanceof MotorisedBlock.DiagnosticsProvider) {
                MachineDiagnosticsRequest.Client.send((class_1937)world, pos);
            } else {
                this.diagnostics = null;
            }
        }
    }

    public void onRender(class_310 client, class_332 context, float tickDelta) {
        if (this.diagnostics != null) {
            class_327 textRenderer = client.field_1772;
            float width = client.method_22683().method_4486();
            float height = client.method_22683().method_4502();
            boolean problem = this.diagnostics.problem();
            if (problem) {
                class_2561 t = this.diagnostics.title();
                class_2561 m = this.diagnostics.message();
                int textWidth = textRenderer.method_27525((class_5348)t);
                Objects.requireNonNull(textRenderer);
                int textHeight = 9;
                GUIUtil.drawText(context, textRenderer, t, (width - (float)textWidth) / 2.0f, (height + 1.5f * (float)textHeight) / 2.0f, Color.RED.getRGB(), true);
                textWidth = textRenderer.method_27525((class_5348)m);
                GUIUtil.drawText(context, textRenderer, m, (width - (float)textWidth) / 2.0f, (height + 3.5f * (float)textHeight) / 2.0f, Color.RED.getRGB(), true);
            }
        }
    }

    public static void init() {
    }
}

