/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.meatgun.animation;

import com.neep.meatweapons.client.meatgun.animation.AnimatedAction;
import com.neep.meatweapons.client.meatgun.animation.MeatgunAnimation;
import com.neep.meatweapons.client.meatgun.animation.RenderAction;
import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import com.neep.meatweapons.meatgun.module.ShortPhageRayModule;
import com.neep.neepmeat.util.Easing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DrillPhageRayHoldMeatgunAnimation
extends AnimatedAction<MeatgunComponent, DrillPhageRayHoldMeatgunAnimation>
implements MeatgunAnimation {
    private boolean started = false;
    private final RenderAction.Sequence<DrillPhageRayHoldMeatgunAnimation> down = new RenderAction.Sequence<DrillPhageRayHoldMeatgunAnimation>(){

        @Override
        public void tick(DrillPhageRayHoldMeatgunAnimation parent, MeatgunComponent component, int counter) {
            @Nullable MeatgunModule module = component.getRootHolder().moduleCache().findModule(MeatgunModules.SHORT_PHAGE_RAY);
            if (module instanceof ShortPhageRayModule) {
                ShortPhageRayModule phageRay = (ShortPhageRayModule)module;
                if (phageRay.triggerHeld()) {
                    DrillPhageRayHoldMeatgunAnimation.this.started = true;
                } else if (DrillPhageRayHoldMeatgunAnimation.this.started) {
                    DrillPhageRayHoldMeatgunAnimation.this.setSequence(DrillPhageRayHoldMeatgunAnimation.this.up);
                }
            } else {
                DrillPhageRayHoldMeatgunAnimation.this.markFinished();
            }
        }

        @Override
        public boolean applyRender(class_4587 matrices, int counter, float tickDelta, boolean leftHand) {
            float time = (float)counter + tickDelta;
            float delta = time / 2.0f;
            float ease = Math.min(1.0f, (float)Easing.easeInCubic(delta));
            float rx = 3.0f * ease;
            DrillPhageRayHoldMeatgunAnimation.applyIdle(matrices, rx, 0.0f, 0.0f, leftHand);
            return false;
        }
    };
    private final RenderAction.Sequence<DrillPhageRayHoldMeatgunAnimation> up = new RenderAction.Sequence<DrillPhageRayHoldMeatgunAnimation>(){

        @Override
        public void tick(DrillPhageRayHoldMeatgunAnimation parent, MeatgunComponent component, int counter) {
            @Nullable MeatgunModule module = component.getRootHolder().moduleCache().findModule(MeatgunModules.SHORT_PHAGE_RAY);
            if (module instanceof ShortPhageRayModule) {
                ShortPhageRayModule phageRay = (ShortPhageRayModule)module;
                if (phageRay.triggerHeld()) {
                    DrillPhageRayHoldMeatgunAnimation.this.started = true;
                } else if (DrillPhageRayHoldMeatgunAnimation.this.started) {
                    DrillPhageRayHoldMeatgunAnimation.this.markFinished();
                }
            } else {
                DrillPhageRayHoldMeatgunAnimation.this.markFinished();
            }
        }

        @Override
        public boolean applyRender(class_4587 matrices, int counter, float tickDelta, boolean leftHand) {
            float time = (float)counter + tickDelta;
            float delta = time / 2.0f;
            float ease = (float)Math.max(0.0, 1.0 - Easing.easeInCubic(delta));
            float rx = 3.0f * ease;
            DrillPhageRayHoldMeatgunAnimation.applyIdle(matrices, rx, 0.0f, 0.0f, leftHand);
            return false;
        }
    };

    public static void applyIdle(class_4587 matrices, float xRot, float yRot, float zRot, boolean leftHand) {
        float i = leftHand ? -1.0f : 1.0f;
        float d = leftHand ? 1.0f : 0.0f;
        matrices.method_22904((double)d, 0.0, 1.5);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(i * yRot));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(xRot));
        matrices.method_22904((double)(-d), 0.0, -1.5);
        matrices.method_46416(d, 0.0f, d);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(i * zRot));
        matrices.method_46416(-d, 0.0f, -d);
    }

    @Override
    public void start(@Nullable class_2540 buf) {
        super.start(buf);
        this.setSequence(this.down);
        this.started = false;
    }

    @Override
    public boolean canStop(MeatgunAnimation replace) {
        return replace == this;
    }
}

