/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.instance;

import com.neep.meatlib.client.flw.MeatModels;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.machine.live_machine.block.TreeVacuumBlock;
import com.neep.neepmeat.machine.live_machine.block.entity.TreeVacuumBlockEntity;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class TreeVacuumVisual
extends AbstractBlockEntityVisual<TreeVacuumBlockEntity>
implements SimpleDynamicVisual {
    private final TransformedInstance lungL;
    private final TransformedInstance lungR;
    private final TransformedInstance plunger;

    public TreeVacuumVisual(VisualizationContext ctx, TreeVacuumBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
        this.lungL = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.TREE_VACUUM_LUNG)).createInstance();
        this.lungR = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.TREE_VACUUM_LUNG)).createInstance();
        this.plunger = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.TREE_VACUUM_PLUNGER)).createInstance();
    }

    public void _delete() {
        this.lungL.delete();
        this.lungR.delete();
        this.plunger.delete();
    }

    private float easeOutSine(float x) {
        return class_3532.method_15374((float)(x * (float)Math.PI / 2.0f));
    }

    public void beginFrame(DynamicVisual.Context context) {
        class_2350 facing = (class_2350)((TreeVacuumBlockEntity)this.blockEntity).method_11010().method_11654((class_2769)TreeVacuumBlock.FACING);
        int animationTicks = ((TreeVacuumBlockEntity)this.blockEntity).animationTicks;
        float t = (float)animationTicks - (animationTicks > 0 ? context.partialTick() : 0.0f);
        float plungerOffset = t > 7.0f ? this.easeOutSine(1.0f - (t - 7.0f) / 3.0f) : this.easeOutSine(t / 7.0f);
        float tRad = (float)Math.PI * 2 * t / 10.0f + (float)Math.PI;
        float sf = 1.0f + 0.2f * (class_3532.method_15362((float)tRad) + 1.0f) / 2.0f;
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.plunger.setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotateToFace(facing)).uncenter()).translate(0.0f, 0.0f, 0.4375f * plungerOffset);
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.lungL.setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotateToFace(facing)).uncenter()).translate(-0.125, 0.5, 0.5)).scale(sf, 1.0f, sf).translate(0.125, -0.5, -0.5);
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.lungR.setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotateToFace(facing)).uncenter()).translate(0.8125f, 0.0f, 0.25f).rotate((float)Math.PI, (Vector3fc)class_2350.field_11036.method_23955())).translate(-0.8125f, 0.0f, -0.25f).translate(0.625f, 0.0f, 0.0f).translate(-0.125, 0.5, 0.0)).scale(sf, 1.0f, sf).translate(0.125, -0.5, 0.0);
        this.plunger.setChanged();
        this.lungL.setChanged();
        this.lungR.setChanged();
    }

    public void updateLight(float v) {
        this.relight(this.pos, new FlatLit[]{this.lungL, this.lungR, this.plunger});
    }

    public static void initNetwork() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TreeVacuumBlockEntity.CHANNEL_ID, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            boolean playSound = buf.readBoolean();
            client.execute(() -> {
                class_2586 patt5678$temp = client.field_1687.method_8321(pos);
                if (patt5678$temp instanceof TreeVacuumBlockEntity) {
                    TreeVacuumBlockEntity be = (TreeVacuumBlockEntity)patt5678$temp;
                    be.startAnimation(playSound, (class_1657)client.field_1724);
                }
            });
        });
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }
}

