/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.instance;

import com.neep.meatlib.client.flw.MeatModels;
import com.neep.meatlib.client.flw.RelightingEntityVisual;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.entity.skyworm.SkywormEntity;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import org.joml.Vector3fc;

public class SkywormVisual
extends RelightingEntityVisual<SkywormEntity>
implements SimpleDynamicVisual {
    private final ObjectArrayList<TransformedInstance> body;
    private final FloatList scales = new FloatArrayList();

    public SkywormVisual(VisualizationContext ctx, SkywormEntity entity, float partialTick) {
        super(ctx, entity, partialTick);
        this.body = new ObjectArrayList();
        for (int i = 0; i < entity.getLength(); ++i) {
            this.body.add((Object)((TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.cutout(NMExtraModels.SKYWORM_SEGMENT)).createInstance()));
            this.scales.add(1.0f);
        }
    }

    public void beginFrame(DynamicVisual.Context context) {
        int segmentHeight = 5;
        float tickDelta = context.partialTick();
        float twistOffset = 0.4f;
        float wobbleMagnitude = ((SkywormEntity)this.entity).allowWobble() ? 0.3f : 0.1f;
        float wobbleX = class_3532.method_15374((float)(((float)((SkywormEntity)this.entity).field_6012 + tickDelta) / 10.0f)) * wobbleMagnitude;
        float wobbleZ = class_3532.method_15362((float)(((float)((SkywormEntity)this.entity).field_6012 + tickDelta) / 15.0f)) * wobbleMagnitude;
        boolean below = ((SkywormEntity)this.entity).getFromBelow();
        int m = below ? -1 : 1;
        int bulgeIdx = ((SkywormEntity)this.entity).getBulge();
        for (int i = 0; i < this.body.size(); ++i) {
            float scale = this.scales.getFloat(i);
            if (i == bulgeIdx) {
                scale = 1.2f;
            }
            scale = class_3532.method_16439((float)0.1f, (float)scale, (float)1.0f);
            this.scales.set(i, scale);
            float angle = 0.0f;
            float twist = this.getVisualPosition((float)tickDelta).y / 10.0f + (float)i * (float)Math.PI / 5.0f;
            TransformedInstance segment = (TransformedInstance)this.body.get(i);
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)segment.setIdentityTransform().translate((Vector3fc)this.getVisualPosition(tickDelta).add(0.0f, (float)(m * i * segmentHeight - (below ? segmentHeight - 1 : 0)), 0.0f))).translate(wobbleX, 0.0f, wobbleZ).scale(scale, scale, scale).translate(twistOffset, 0.0f, 0.0f).rotate(twist, class_2350.class_2351.field_11052)).translate(-twistOffset, 0.0f, 0.0f).rotate(angle, class_2350.class_2351.field_11052)).translate(-0.5, 0.0, -0.5);
            this.relight(tickDelta, new FlatLit[]{segment});
            segment.setChanged();
        }
    }

    protected void _delete() {
        for (TransformedInstance thing : this.body) {
            thing.delete();
        }
    }

    public void updateLight(float v) {
        for (TransformedInstance transformedInstance : this.body) {
            this.relight(v, new FlatLit[]{transformedInstance});
        }
    }
}

