/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.instance;

import com.neep.meatlib.client.flw.MeatModels;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.machine.reactor.block.entity.DisruptorSegmentBlockEntity;
import com.neep.neepmeat.machine.reactor.disruptor.DisruptorSegmentBlock;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class DisruptorSegmentVisual
extends AbstractBlockEntityVisual<DisruptorSegmentBlockEntity>
implements SimpleDynamicVisual {
    private final TransformedInstance centre;
    private final TransformedInstance[] arms;
    private float rotSpeedRadians;
    private float rotation;
    private float lerpExtension = -1.0f;

    public DisruptorSegmentVisual(VisualizationContext ctx, DisruptorSegmentBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
        this.centre = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.DISRUPTOR_SEGMENT_CENTRE)).createInstance();
        this.arms = new TransformedInstance[4];
        for (int i = 0; i < 4; ++i) {
            this.arms[i] = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.DISRUPTOR_SEGMENT_ARM)).createInstance();
        }
    }

    public void _delete() {
        this.centre.delete();
        for (TransformedInstance arm : this.arms) {
            arm.delete();
        }
    }

    public void beginFrame(DynamicVisual.Context context) {
        if (!class_310.method_1551().method_1493()) {
            this.rotSpeedRadians = class_3532.method_16439((float)0.1f, (float)this.rotSpeedRadians, (float)(((DisruptorSegmentBlockEntity)this.blockEntity).progressIncrement() * 0.1f));
            this.rotation += this.rotSpeedRadians;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)((DisruptorSegmentBlockEntity)this.blockEntity).method_11010().method_11654(DisruptorSegmentBlock.AXIS);
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.centre.setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotate((Quaternionfc)this.getRotation(axis)).rotate(this.rotation, (Vector3fc)class_2350.field_11036.method_23955())).uncenter();
        float extension = -0.6875f * class_3532.method_15363((float)((float)((DisruptorSegmentBlockEntity)this.blockEntity).getDisruption() / 20.0f), (float)0.0f, (float)1.0f);
        this.lerpExtension = this.lerpExtension == -1.0f ? extension : class_3532.method_16439((float)0.1f, (float)this.lerpExtension, (float)extension);
        for (int i = 0; i < this.arms.length; ++i) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.arms[i].setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotate((Quaternionfc)this.getRotation(axis)).rotate((float)i / 4.0f * ((float)Math.PI * 2) + this.rotation, (Vector3fc)class_2350.field_11036.method_23955())).uncenter()).translate(0.0f, 0.0f, this.lerpExtension);
            this.arms[i].setChanged();
        }
        this.centre.setChanged();
    }

    private Quaternionf getRotation(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> class_7833.field_40717.rotationDegrees(90.0f);
            case class_2350.class_2351.field_11052 -> new Quaternionf();
            case class_2350.class_2351.field_11051 -> class_7833.field_40713.rotationDegrees(90.0f);
        };
    }

    public void updateLight(float v) {
        this.relight(this.pos, (FlatLit[])this.arms);
        this.relight(this.pos, new FlatLit[]{this.centre});
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }
}

