/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.block.entity.machine;

import com.neep.meatlib.block.BaseHorFacingBlock;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.transfer.MultiFluidBuffer;
import com.neep.neepmeat.api.multiblock.ControllerBlockEntity;
import com.neep.neepmeat.api.multiblock.MultiBlock;
import com.neep.neepmeat.api.storage.MultiItemBuffer;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.block.vat.VatComponent;
import com.neep.neepmeat.block.vat.VatControllerBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class VatControllerBlockEntity
extends SyncableBlockEntity
implements ControllerBlockEntity {
    protected boolean assembled;
    public List<class_2338> blocks;
    public List<class_2338> ports;
    protected Storages storages = new Storages(this);

    public VatControllerBlockEntity(class_2338 pos, class_2680 state) {
        this(null, pos, state);
    }

    public VatControllerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.blocks = new ArrayList<class_2338>();
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.assembled = nbt.method_10577("assembled");
        class_2499 list = (class_2499)nbt.method_10580("blocks");
        if (list != null) {
            this.blocks.addAll(list.stream().map(element -> class_2512.method_10691((class_2487)((class_2487)element))).collect(Collectors.toList()));
        }
        this.storages.readNbt(nbt);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556("assembled", this.isAssembled());
        class_2499 list = new class_2499();
        if (this.blocks != null) {
            list.addAll((Collection)this.blocks.stream().map(class_2512::method_10692).collect(Collectors.toList()));
        }
        nbt.method_10566("blocks", (class_2520)list);
        this.storages.writeNbt(nbt);
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
    }

    public boolean tryAssemble(class_3218 world) {
        class_2338 origin = this.method_11016();
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)BaseHorFacingBlock.field_11177);
        class_2338 centre = origin.method_10093(facing.method_10153());
        this.blocks = VatControllerBlockEntity.checkValid(world, centre);
        if (this.blocks == null) {
            return false;
        }
        this.blocks.remove(this.method_11016());
        this.blocks.stream().map(pos1 -> {
            MultiBlock.Entity entity;
            class_2586 patt4197$temp = world.method_8321(pos1);
            return patt4197$temp instanceof MultiBlock.Entity ? (entity = (MultiBlock.Entity)patt4197$temp) : null;
        }).filter(Objects::nonNull).forEach(be -> be.setController(this.method_11016()));
        world.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)VatControllerBlock.ASSEMBLED, (Comparable)Boolean.valueOf(true)), 2);
        this.assembled = true;
        this.method_5431();
        return true;
    }

    public boolean disassemble(class_3218 world, boolean replaced) {
        this.blocks.stream().map(arg_0 -> ((class_3218)world).method_8321(arg_0)).filter(Objects::nonNull).forEach(be -> {
            if (be instanceof MultiBlock.Entity) {
                MultiBlock.Entity entity = (MultiBlock.Entity)((Object)be);
                entity.setController(null);
            }
        });
        if (!replaced) {
            world.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)VatControllerBlock.ASSEMBLED, (Comparable)Boolean.valueOf(false)), 2);
        }
        this.blocks.clear();
        this.assembled = false;
        this.dropItems((class_1937)world);
        this.method_5431();
        System.out.println("Disassemble");
        return true;
    }

    protected void dropItems(class_1937 world) {
        Transaction transaction = Transaction.openOuter();
        Iterator iterator = this.storages.items.iterator();
        while (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            if (view.isResourceBlank()) continue;
            class_1264.method_5449((class_1937)world, (double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260(), (class_1799)((ItemVariant)view.getResource()).toStack((int)view.getAmount()));
            view.extract((Object)((ItemVariant)view.getResource()), Long.MAX_VALUE, (TransactionContext)transaction);
        }
        transaction.commit();
    }

    public static List<class_2338> checkValid(class_3218 world, class_2338 centre) {
        boolean valid = true;
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        for (int i = 0; i < 3; ++i) {
            List<class_2338> list = VatControllerBlockEntity.checkOddSquare((class_1937)world, centre.method_10069(0, i, 0), 1, state -> state.method_26204() instanceof VatComponent);
            if (list != null) {
                blocks.addAll(list);
                continue;
            }
            valid = false;
        }
        List<class_2338> list = VatControllerBlockEntity.checkOddRing((class_1937)world, centre.method_10069(0, 3, 0), 1, state -> state.method_26204() instanceof VatComponent);
        if (list != null) {
            blocks.addAll(list);
        } else {
            valid = false;
        }
        boolean bl = valid = valid && blocks.stream().filter(pos1 -> world.method_8320(pos1).method_26204() instanceof VatControllerBlock).count() == 1L;
        if (!valid) {
            return null;
        }
        return blocks;
    }

    public static List<class_2338> checkOddSquare(class_1937 world, class_2338 centre, int radius, Predicate<class_2680> predicate) {
        class_2338.class_2339 mutable = centre.method_25503();
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        int y = centre.method_10264();
        for (int i = -radius; i < radius + 1; ++i) {
            for (int j = -radius; j < radius + 1; ++j) {
                mutable.method_10103(centre.method_10263() + i, y, centre.method_10260() + j);
                class_2680 state = world.method_8320((class_2338)mutable);
                if (!predicate.test(state)) {
                    return null;
                }
                list.add(mutable.method_10062());
            }
        }
        return list;
    }

    public static List<class_2338> checkOddRing(class_1937 world, class_2338 centre, int radius, Predicate<class_2680> predicate) {
        class_2338.class_2339 mutable = centre.method_25503();
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        int y = centre.method_10264();
        for (int i = -radius; i < radius + 1; i += radius * 2) {
            class_2680 state;
            int j;
            for (j = -radius; j < radius + 1; ++j) {
                mutable.method_10103(centre.method_10263() + i, y, centre.method_10260() + j);
                state = world.method_8320((class_2338)mutable);
                if (!predicate.test(state)) {
                    return null;
                }
                list.add(mutable.method_10062());
            }
            for (j = -radius + 1; j < radius; ++j) {
                mutable.method_10103(centre.method_10263() + j, y, centre.method_10260() + i);
                state = world.method_8320((class_2338)mutable);
                if (!predicate.test(state)) {
                    return null;
                }
                list.add(mutable.method_10062());
            }
        }
        return list;
    }

    public Storage<FluidVariant> getFluidStorage() {
        return this.storages.fluids;
    }

    public Storage<ItemVariant> getItemStorage() {
        return this.storages.items;
    }

    public boolean isAssembled() {
        return this.assembled;
    }

    @Override
    public <V extends TransferVariant<?>> Storage<V> getStorage(Class<V> variant) {
        if (variant.equals(ItemVariant.class)) {
            return this.storages.items;
        }
        if (variant.equals(FluidVariant.class)) {
            return this.storages.fluids;
        }
        return Storage.empty();
    }

    @Override
    public void componentBroken(class_3218 world) {
        this.disassemble(world, false);
    }

    protected static class Storages {
        protected WritableStackStorage itemInput = new WritableStackStorage(parent::sync);
        protected WritableStackStorage itemOutput = new WritableStackStorage(parent::sync);
        protected MultiItemBuffer items = new MultiItemBuffer(List.of(this.itemInput, this.itemOutput));
        protected MultiFluidBuffer fluids = new MultiFluidBuffer(1296000L, type -> true, parent::sync);

        protected Storages(SyncableBlockEntity parent) {
        }

        public void readNbt(class_2487 nbt) {
            this.items.readNbt(nbt);
            this.fluids.readNbt(nbt);
        }

        public class_2487 writeNbt(class_2487 nbt) {
            this.items.writeNbt(nbt);
            this.fluids.writeNbt(nbt);
            return nbt;
        }
    }
}

