/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class MotorisedMachineBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock,
MotorisedBlock.DiagnosticsProvider {
    protected float power;
    protected float lastPower;
    protected float progressIncrement;
    public final float minPower;
    protected final float maxIncrement;

    public MotorisedMachineBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, float minPower, float maxIncrement) {
        super(type, pos, state);
        this.minPower = minPower;
        this.maxIncrement = maxIncrement;
    }

    @Override
    public MotorisedBlock.Diagnostics getDiagnostics() {
        return MotorisedBlock.Diagnostics.insufficientPower(this.power < this.minPower, this.power, this.minPower);
    }

    public void serverTick() {
        if (this.lastPower != this.power) {
            this.lastPower = this.power;
            this.sync();
        }
    }

    @Override
    public void setInputPower(float power) {
        if (this.power != power) {
            this.power = power;
            this.progressIncrement = power < this.minPower ? 0.0f : Math.min(power, this.maxIncrement);
            this.sync();
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("power", this.power);
        nbt.method_10548("increment", this.progressIncrement);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.power = nbt.method_10583("power");
        this.progressIncrement = nbt.method_10583("increment");
    }

    public float progressIncrement() {
        return this.progressIncrement;
    }

    public float maxIncrement() {
        return this.maxIncrement;
    }
}

