/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.storage;

import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class WritableStackStorage
extends SingleVariantStorage<ItemVariant>
implements StorageView<ItemVariant> {
    protected final int capacity;
    protected Runnable callback;

    public WritableStackStorage(@Nullable Runnable parent) {
        this(parent, 64);
    }

    public WritableStackStorage(@Nullable Runnable parent, int capacity) {
        this.callback = parent;
        this.capacity = capacity;
    }

    protected void onFinalCommit() {
        this.syncIfPossible();
    }

    public class_2487 toNbt(class_2487 nbt) {
        this.writeNbt(nbt);
        return nbt;
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10544("amount", this.getAmount());
        nbt.method_10566("resource", (class_2520)((ItemVariant)this.getResource()).toNbt());
    }

    public void readNbt(class_2487 nbt) {
        this.amount = nbt.method_10537("amount");
        this.variant = ItemVariant.fromNbt((class_2487)((class_2487)nbt.method_10580("resource")));
    }

    public void syncIfPossible() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public void setStack(class_1799 stack) {
        this.variant = ItemVariant.of((class_1799)stack);
        this.amount = stack.method_7947();
        this.syncIfPossible();
    }

    public class_1799 getAsStack() {
        return ((ItemVariant)this.variant).toStack((int)this.getAmount());
    }

    public boolean isEmpty() {
        return this.amount == 0L || ((ItemVariant)this.variant).isBlank();
    }

    protected ItemVariant getBlankVariant() {
        return ItemVariant.blank();
    }

    protected long getCapacity(ItemVariant variant) {
        if (!variant.isBlank()) {
            return Math.min(variant.getItem().method_7882(), this.capacity);
        }
        return this.capacity;
    }

    public static boolean handleInteract(class_1657 player, class_1268 hand, SingleVariantStorage<ItemVariant> storage) {
        class_1799 stack = player.method_5998(hand);
        if (!(!stack.method_7960() && ((ItemVariant)storage.getResource()).matches(stack) || storage.isResourceBlank())) {
            try (Transaction transaction = Transaction.openOuter();){
                ItemVariant resource = (ItemVariant)storage.getResource();
                long extracted = storage.extract((TransferVariant)resource, Long.MAX_VALUE, (TransactionContext)transaction);
                class_1799 giveStack = resource.toStack((int)extracted);
                boolean give = player.method_31548().method_7394(giveStack);
                if (!giveStack.method_7960()) {
                    player.method_7328(giveStack, false);
                }
                transaction.commit();
                boolean bl = true;
                return bl;
            }
        }
        if (storage.isResourceBlank() && !stack.method_7960()) {
            try (Transaction transaction = Transaction.openOuter();){
                long inserted = storage.insert((TransferVariant)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
                stack.method_7934((int)inserted);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void extractDirect(int amount) {
        this.amount = Math.max(0L, this.amount - (long)amount);
        if (this.amount == 0L) {
            this.variant = ItemVariant.blank();
        }
    }
}

