/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.storage;

import com.neep.neepmeat.fluid.MixableFluid;
import com.neep.neepmeat.implant.entity.ImplantManager;
import com.neep.neepmeat.implant.item.LivingToolImplant;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.item.LivingToolImplantItem;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class WritableSingleFluidStorage
extends SingleVariantStorage<FluidVariant>
implements StorageView<FluidVariant> {
    public static final String KEY_RESOURCE = "resource";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_CAPACITY = "capacity";
    protected long capacity;
    public float renderLevel;
    public Runnable finalCallback;

    public WritableSingleFluidStorage(long capacity, Runnable finalCallback) {
        this(capacity);
        this.finalCallback = finalCallback;
    }

    public WritableSingleFluidStorage(long capacity) {
        this.capacity = capacity;
        this.finalCallback = () -> {};
    }

    @Nullable
    public static Storage<FluidVariant> findFluidStorage(class_1799 stack, class_1657 player, class_1268 hand) {
        ImplantManager manager;
        ContainerItemContext cic = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
        Storage<FluidVariant> storage = (Storage<FluidVariant>)FluidStorage.ITEM.find(stack, (Object)cic);
        if (storage == null && (manager = (ImplantManager)NMComponents.IMPLANT_MANAGER.getNullable((Object)stack)) != null && manager.isInstalled(LivingToolImplant.ID) && (storage = LivingToolImplantItem.getStorage(stack, cic)) != null) {
            return storage;
        }
        return storage;
    }

    public static boolean handleInteract(Storage<FluidVariant> buffer, class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        Storage<FluidVariant> storage = WritableSingleFluidStorage.findFluidStorage(stack, player, hand);
        if (world.method_8608()) {
            return true;
        }
        if (storage != null) {
            Transaction transaction;
            if (player.method_7337()) {
                transaction = Transaction.openOuter();
                try {
                    Iterator it = storage.iterator();
                    if (it.hasNext()) {
                        StorageView view = (StorageView)it.next();
                        if (!view.isResourceBlank()) {
                            class_3414 bucketFillSound = FluidVariantAttributes.getEmptySound((FluidVariant)((FluidVariant)view.getResource()));
                            world.method_8396(null, player.method_24515(), bucketFillSound, class_3419.field_15245, 1.0f, 1.5f);
                            buffer.insert((Object)((FluidVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction);
                            transaction.commit();
                            boolean bl = true;
                            return bl;
                        }
                        transaction.abort();
                    }
                }
                finally {
                    if (transaction != null) {
                        transaction.close();
                    }
                }
            }
            transaction = Transaction.openOuter();
            try {
                class_3414 class_34142;
                FluidVariant stored = (FluidVariant)StorageUtil.findStoredResource(storage);
                class_3414 empty = stored != null ? FluidVariantAttributes.getEmptySound((FluidVariant)stored) : class_3417.field_14834;
                try (Transaction inner = transaction.openNested();){
                    if (StorageUtil.move(storage, buffer, variant -> true, (long)Long.MAX_VALUE, (TransactionContext)inner) > 0L) {
                        world.method_8396(null, player.method_24515(), empty, class_3419.field_15245, 1.0f, 1.5f);
                        inner.commit();
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                    inner.abort();
                }
                if (buffer instanceof StorageView) {
                    StorageView view = (StorageView)buffer;
                    class_34142 = FluidVariantAttributes.getFillSound((FluidVariant)((FluidVariant)view.getResource()));
                } else {
                    class_34142 = class_3417.field_15126;
                }
                class_3414 fill = class_34142;
                try (Transaction inner = transaction.openNested();){
                    if (StorageUtil.move(buffer, storage, variant -> true, (long)Long.MAX_VALUE, (TransactionContext)inner) > 0L) {
                        world.method_8396(null, player.method_24515(), fill, class_3419.field_15245, 1.0f, 1.5f);
                        inner.commit();
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                    inner.abort();
                }
                transaction.abort();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        return false;
    }

    protected FluidVariant getBlankVariant() {
        return FluidVariant.blank();
    }

    protected long getCapacity(FluidVariant variant) {
        return this.capacity;
    }

    protected boolean variantsCompatible(FluidVariant insertedVariant) {
        return insertedVariant.equals(this.variant) || MixableFluid.canVariantsMix((FluidVariant)this.variant, insertedVariant) && insertedVariant.isOf((Object)((FluidVariant)this.variant).getFluid());
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        long insertedAmount;
        StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
        if ((this.variantsCompatible(insertedVariant) || ((FluidVariant)this.variant).isBlank()) && this.canInsert((TransferVariant)insertedVariant) && (insertedAmount = Math.min(maxAmount, this.getCapacity(insertedVariant) - this.amount)) > 0L) {
            this.updateSnapshots(transaction);
            if (((FluidVariant)this.variant).isBlank()) {
                this.variant = insertedVariant;
                this.amount = insertedAmount;
            } else {
                if (MixableFluid.canVariantsMix((FluidVariant)this.variant, insertedVariant)) {
                    this.variant = ((MixableFluid)((FluidVariant)this.variant).getFluid()).mixNbt((FluidVariant)this.variant, this.amount, insertedVariant, insertedAmount);
                }
                this.amount += insertedAmount;
            }
            return insertedAmount;
        }
        return 0L;
    }

    protected void onFinalCommit() {
        if (this.finalCallback != null) {
            this.finalCallback.run();
        }
    }

    public static FluidVariant readFluidVariant(class_2487 nbt) {
        return FluidVariant.fromNbt((class_2487)nbt.method_10562(KEY_RESOURCE));
    }

    public static long readAmount(class_2487 nbt) {
        return nbt.method_10537(KEY_AMOUNT);
    }

    public static long readCapacity(class_2487 nbt) {
        return nbt.method_10537(KEY_CAPACITY);
    }

    public class_2487 toNbt(class_2487 nbt) {
        this.writeNbt(nbt);
        return nbt;
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10566(KEY_RESOURCE, (class_2520)((FluidVariant)this.getResource()).toNbt());
        nbt.method_10544(KEY_AMOUNT, this.amount);
        nbt.method_10544(KEY_CAPACITY, this.capacity);
    }

    public class_2487 readNbt(class_2487 nbt) {
        this.variant = WritableSingleFluidStorage.readFluidVariant(nbt);
        this.amount = WritableSingleFluidStorage.readAmount(nbt);
        return nbt;
    }
}

