/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.storage;

import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class LazyBlockApiCacheImpl<A, C>
implements LazyBlockApiCache<A, C> {
    private BlockApiCache<A, C> cache = null;
    private final Supplier<class_3218> worldSupplier = () -> {
        Object patt1697$temp = worldSupplier.get();
        if (patt1697$temp instanceof class_3218) {
            class_3218 serverWorld = (class_3218)patt1697$temp;
            return serverWorld;
        }
        throw new IllegalArgumentException("LazyBlockApiCache queried on the client!");
    };
    private final BlockApiLookup<A, C> lookup;
    private final class_2338 pos;
    private final Supplier<C> ctxSupplier;

    LazyBlockApiCacheImpl(Supplier<class_1937> worldSupplier, BlockApiLookup<A, C> lookup, class_2338 pos, Supplier<C> ctxSupplier) {
        this.lookup = lookup;
        this.pos = pos;
        this.ctxSupplier = ctxSupplier;
    }

    @Override
    public A find() {
        this.validate();
        return (A)this.cache.find(this.ctxSupplier.get());
    }

    @Override
    @Nullable
    public class_2586 getBlockEntity() {
        this.validate();
        return this.cache.getBlockEntity();
    }

    @Override
    public void invalidate() {
        this.cache = null;
    }

    private void validate() {
        if (this.cache == null) {
            this.cache = BlockApiCache.create(this.lookup, (class_3218)this.worldSupplier.get(), (class_2338)this.pos);
        }
    }

    @Override
    public class_2338 pos() {
        return this.pos;
    }

    @Override
    public C ctx() {
        return this.ctxSupplier.get();
    }
}

