/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.processing.random_ores;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.neepmeat.api.processing.random_ores.Function;
import com.neep.neepmeat.api.processing.random_ores.WeightModifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class BiomeListWeightModifier
implements WeightModifier {
    public static final Codec<BiomeListWeightModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)class_2960.field_25139).fieldOf("biomes").forGetter(m -> m.biomes), (App)Codec.FLOAT.fieldOf("value").forGetter(m -> Float.valueOf(m.value)), (App)Function.CODEC.fieldOf("function").forGetter(m -> m.function)).apply((Applicative)instance, BiomeListWeightModifier::new));
    private final List<class_2960> biomes;
    private final Set<class_2960> biomeSet;
    private final float value;
    private final Function function;

    public BiomeListWeightModifier(List<class_2960> biomes, float value, Function function) {
        this.biomes = biomes;
        this.value = value;
        this.function = function;
        this.biomeSet = new HashSet<class_2960>(biomes);
    }

    @Override
    public float apply(float base, class_1937 world, class_2338 pos) {
        class_6880 biome = world.method_23753(pos);
        class_5321 key = biome.method_40230().orElse(null);
        if (key != null && this.biomeSet.contains(key.method_29177())) {
            return switch (this.function) {
                default -> throw new IncompatibleClassChangeError();
                case Function.ADD -> base + this.value;
                case Function.MUL -> base * this.value;
            };
        }
        return base;
    }

    @Override
    public Codec<? extends WeightModifier> getCodec() {
        return CODEC;
    }
}

