/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.processing.ball_mill;

import com.neep.meatlib.api.event.DataPackPostProcess;
import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.meatlib.network.GlobalChannelManager;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.neepmeat.api.processing.ball_mill.BallMillRecipe;
import com.neep.neepmeat.api.processing.ball_mill.DistinctBallMillRecipe;
import com.neep.neepmeat.init.NMrecipeTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BallMillRecipeGenerator {
    private final Map<class_2960, BallMillRecipe> syntheticRecipes = new HashMap<class_2960, BallMillRecipe>();
    private final List<RegistryRecipeInput<class_1792>> usedInputs = new ObjectArrayList();
    private static final GlobalChannelManager<Consumer<Map<class_2960, BallMillRecipe>>> SYNC = GlobalChannelManager.create(new class_2960("neepmeat", "sync_ball_mill"), ChannelFormat.builder(ParamCodecs.as(Consumer.class)).param(ParamCodecs.map(ParamCodecs.as(Map.class), ParamCodecs.IDENTIFIER, DistinctBallMillRecipe.PARAM_CODEC)).build());
    public static final BallMillRecipeGenerator INSTANCE = new BallMillRecipeGenerator();

    public static void init() {
    }

    private BallMillRecipeGenerator() {
        DataPackPostProcess.AFTER_DATA_PACK_LOAD.register(DataPackPostProcess.FIRST, this::generate);
        DataPackPostProcess.SYNC.register(this::sync);
        SYNC.receiver(EnvType.CLIENT, m -> {
            this.syntheticRecipes.clear();
            this.syntheticRecipes.putAll((Map<class_2960, BallMillRecipe>)m);
        });
    }

    private void generate(MinecraftServer server) {
        this.syntheticRecipes.clear();
        this.usedInputs.clear();
        MeatlibRecipes.getInstance().getAllValuesOfType(NMrecipeTypes.BALL_MILL).forEach(r -> this.usedInputs.add(r.getInput()));
    }

    private void sync(MinecraftServer server, Set<class_3222> serverPlayerEntities) {
        serverPlayerEntities.forEach(p -> SYNC.emitter((class_1657)p).accept(this.syntheticRecipes));
    }

    public void add(String name, RegistryRecipeInput<class_1792> input, ItemVariant output) {
        if (this.usedInputs.stream().noneMatch(i -> i.resourcesMatch(input))) {
            class_2960 recipeId = new class_2960("neepmeat", "/synthetic/" + name + "_ball_mill");
            this.syntheticRecipes.put(recipeId, new DistinctBallMillRecipe(recipeId, input, List.of(RecipeOutputs.of(output, 1L, 1L, 1.0f), RecipeOutputs.of(output, 1L, 1L, 0.2f)), 40));
        }
    }

    public void clear() {
        this.syntheticRecipes.clear();
    }

    public Optional<BallMillRecipe> getFirstMatch(BallMillRecipe.BallMillContext context) {
        Optional<BallMillRecipe> first = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.BALL_MILL, context);
        if (first.isPresent()) {
            return first;
        }
        return this.syntheticRecipes.values().stream().filter(r -> r.matches(context)).findFirst();
    }

    public Collection<BallMillRecipe> getSynthetic() {
        return this.syntheticRecipes.values();
    }
}

