/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.processing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.neep.meatlib.api.event.DataPackPostProcess;
import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.meatlib.api.network.RecordParamCodec;
import com.neep.meatlib.network.GlobalChannelManager;
import com.neep.meatlib.util.StringTokenView;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.init.NMItems;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class OreDustRegistry
implements SimpleSynchronousResourceReloadListener {
    public static final OreDustRegistry ORE_DUST = new OreDustRegistry(new class_2960("neepmeat", "ore_dust"), () -> NMItems.ORE_DUST);
    public static final OreDustRegistry CRUSHED_ORE = new OreDustRegistry(new class_2960("neepmeat", "crushed_ore"), () -> NMItems.CRUSHED_ORE);
    private final Map<class_1792, Entry> dustMap = new IdentityHashMap<class_1792, Entry>();
    private final class_2960 name;
    private final Supplier<class_1792> item;
    private final GlobalChannelManager<Consumer<Map<class_1792, Entry>>> syncChannel;

    public static void init() {
    }

    private OreDustRegistry(class_2960 name, Supplier<class_1792> item) {
        this.name = name;
        this.item = item;
        DataPackPostProcess.SYNC.register(this::sync);
        this.syncChannel = GlobalChannelManager.create(new class_2960(name.method_12836(), "sync_" + name.method_12832()), ChannelFormat.builder(ParamCodecs.as(Consumer.class)).param(ParamCodecs.map(ParamCodecs.as(Map.class), ParamCodecs.registryValue(class_1792.class, class_7923.field_41178), Entry.PARAM_CODEC)).build());
        this.syncChannel.receiver(EnvType.CLIENT, itemEntryMap -> {});
    }

    public void addToItemGroup(class_1761.class_8128 displayContext, class_1761.class_7704 entries) {
        this.dustMap.forEach((i, e) -> entries.method_45420(e.variant.toStack()));
    }

    public class_2960 getFabricId() {
        return this.name;
    }

    public Entry get(class_1792 rawOre) {
        return this.dustMap.computeIfAbsent(rawOre, item1 -> new Entry(this.createItemVariant((class_1792)item1), -1));
    }

    @Nullable
    public Entry getClient(class_1792 rawOre) {
        return this.dustMap.get(rawOre);
    }

    private ItemVariant createItemVariant(class_1792 rawOre) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("ore_item", class_7923.field_41178.method_10221((Object)rawOre).toString());
        return ItemVariant.of((class_1935)((class_1935)this.item.get()), (class_2487)nbt);
    }

    public void method_14491(class_3300 manager) {
        this.dustMap.clear();
        this.readOverrides(manager);
    }

    private void sync(MinecraftServer server, Set<class_3222> players) {
        players.forEach(p -> this.syncChannel.emitter((class_1657)p).accept(this.dustMap));
    }

    private void readOverrides(class_3300 manager) {
        this.dustMap.clear();
        for (class_2960 id : manager.method_14488("ore_dust/overrides", path -> path.method_12832().endsWith(".json")).keySet()) {
            if (!manager.method_14486(id).isPresent()) continue;
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    InputStreamReader reader = new InputStreamReader(stream);
                    JsonElement rootElement = JsonParser.parseReader((Reader)reader);
                    JsonObject rootObject = (JsonObject)rootElement;
                    String resourceName = class_3518.method_15265((JsonObject)rootObject, (String)"output");
                    class_1792 result = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)resourceName));
                    ItemVariant itemVariant = this.createItemVariant(result);
                    int tint = -1;
                    if (rootObject.has("tint")) {
                        JsonElement tintElement = rootObject.get("tint");
                        tint = StringTokenView.parseInteger(tintElement.getAsString());
                    }
                    Entry entry = new Entry(itemVariant, tint);
                    this.dustMap.put(result, entry);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NeepMeat.LOGGER.error("Error while reading ore dust override {}", (Object)id.toString(), (Object)e);
            }
        }
    }

    public Map<class_1792, Entry> getValues() {
        return this.dustMap;
    }

    public record Entry(ItemVariant variant, int tint) {
        public static final ParamCodec<Entry> PARAM_CODEC = RecordParamCodec.builder(Entry.class).param(ParamCodecs.ITEM_VARIANT).param(ParamCodec.INT).build();
    }
}

