/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.processing;

import com.neep.meatlib.api.event.DataPackPostProcess;
import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.meatlib.network.GlobalChannelManager;
import com.neep.meatlib.network.PacketBufUtil;
import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.processing.OreDustRegistry;
import com.neep.neepmeat.api.processing.ball_mill.BallMillRecipeGenerator;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.meatgun.ModuleLootCondition;
import com.neep.neepmeat.mixin.loot.CombinedEntryAccessor;
import com.neep.neepmeat.mixin.loot.ConstantLootNumberProviderAccessor;
import com.neep.neepmeat.mixin.loot.ItemEntryAccessor;
import com.neep.neepmeat.mixin.loot.LeafEntryAccessor;
import com.neep.neepmeat.mixin.loot.SetCountLootFunctionAccessor;
import com.neep.neepmeat.mixin.loot.UniformLootNumberProviderAccessor;
import com.neep.neepmeat.recipe.AdvancedBlockCrushingRecipe;
import com.neep.neepmeat.recipe.BlockCrushingRecipe;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_60;
import net.minecraft.class_65;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockCrushingRegistry {
    private static final GlobalChannelManager<Consumer<SyncData>> SYNC = GlobalChannelManager.create(new class_2960("neepmeat", "block_crushing_sync"), ChannelFormat.builder(ParamCodecs.as(Consumer.class)).param(SyncData.PARAM_CODEC).build());
    public static final BlockCrushingRegistry INSTANCE = new BlockCrushingRegistry();
    private final Map<ItemVariant, Entry> basicInputToEntry = new HashMap<ItemVariant, Entry>();
    private final Map<ItemVariant, Entry> advancedInputToEntry = new HashMap<ItemVariant, Entry>();
    @Nullable
    private BlockCrushingRecipe blockCrushingRecipe;
    @Nullable
    private AdvancedBlockCrushingRecipe advancedBlockCrushingRecipe;

    private BlockCrushingRegistry() {
    }

    private void read(class_1863 manager, SyncData buf) {
        this.blockCrushingRecipe = BlockCrushingRecipe.INSTANCE;
        this.advancedBlockCrushingRecipe = AdvancedBlockCrushingRecipe.INSTANCE;
        this.basicInputToEntry.clear();
        this.advancedInputToEntry.clear();
        this.basicInputToEntry.putAll(buf.basicInputToEntry);
        this.advancedInputToEntry.putAll(buf.advancedInputToEntry);
    }

    public static void init() {
        DataPackPostProcess.AFTER_DATA_PACK_LOAD.register(DataPackPostProcess.ORE_FAT, INSTANCE::reload);
        DataPackPostProcess.SYNC.register(BlockCrushingRegistry::sync);
    }

    private void reload(MinecraftServer server) {
        class_60 lootManager = server.method_3857();
        this.blockCrushingRecipe = BlockCrushingRecipe.INSTANCE;
        this.advancedBlockCrushingRecipe = AdvancedBlockCrushingRecipe.INSTANCE;
        this.searchForLootTables(lootManager);
    }

    @Nullable
    public Entry getFromInputBasic(ItemVariant input) {
        return this.basicInputToEntry.get(input);
    }

    @Nullable
    public Entry getFromInputAdvanced(ItemVariant input) {
        return this.advancedInputToEntry.get(input);
    }

    private void searchForLootTables(class_60 lootManager) {
        NeepMeat.LOGGER.info("Searching for block crushing loot tables");
        class_6862<class_2248> inputs = NMTags.BLOCK_CRUSHING_INPUTS;
        class_7923.field_41178.method_10220().filter(i -> i instanceof class_1747).map(i -> (class_1747)i).filter(i -> i.method_7711().method_40142().method_40220(inputs)).forEach(i -> this.inspectLootTable((class_1792)i, List.of(lootManager.getLootTable((class_2960)i.method_7711().method_26162()).field_943)));
    }

    public List<class_1799> modifyDroppedStacks(class_2680 state, List<class_1799> stacks, boolean includeAll) {
        ObjectArrayList newStacks = new ObjectArrayList();
        boolean oreDropped = false;
        if (state.method_26164(NMTags.DROPS_WITH_DRILL)) {
            newStacks.add(new class_1799((class_1935)state.method_26204().method_8389()));
        } else {
            for (class_1799 stack : stacks) {
                if (stack.method_31573(NMTags.BLOCK_CRUSHING_OUTPUTS) || includeAll && state.method_26164(NMTags.BLOCK_CRUSHING_INPUTS)) {
                    if (oreDropped) continue;
                    newStacks.add(new class_1799((class_1935)state.method_26204().method_8389()));
                    oreDropped = true;
                    continue;
                }
                newStacks.add(stack);
            }
        }
        return newStacks;
    }

    public List<class_1799> modifyDroppedStacks(class_2680 state, class_8567.class_8568 builder, List<class_1799> stacks) {
        if (state.method_26164(NMTags.BLOCK_CRUSHING_INPUTS) && ModuleLootCondition.test((class_1799)builder.method_51873(class_181.field_1229), m -> MeatgunModules.REGISTRY.method_47983(m).method_40220(NMTags.ORE_BLOCK_DROPPING))) {
            return this.modifyDroppedStacks(state, stacks, false);
        }
        return stacks;
    }

    @Nullable
    public InspectedLootTable inspectLootTable(class_1792 blockItem, List<class_55> pools) {
        if (this.advancedBlockCrushingRecipe == null && this.blockCrushingRecipe == null) {
            return null;
        }
        class_6862<class_1792> outputs = NMTags.BLOCK_CRUSHING_OUTPUTS;
        class_6862<class_1792> exclude = NMTags.BLOCK_CRUSHING_OUTPUTS_EXCLUDE;
        for (class_55 pool : pools) {
            for (class_79 entry : pool.field_953) {
                if (!(entry instanceof class_65)) continue;
                class_65 alternativeEntry = (class_65)entry;
                for (class_79 child : ((CombinedEntryAccessor)alternativeEntry).getChildren()) {
                    if (!(child instanceof class_77)) continue;
                    class_77 itemEntry = (class_77)child;
                    class_1792 outputItem = ((ItemEntryAccessor)itemEntry).getItem();
                    boolean isRawOre = outputItem.method_40131().method_40220(outputs);
                    if (isRawOre && !outputItem.method_40131().method_40220(exclude)) {
                        class_117[] lootFunctions;
                        int min = 1;
                        int max = 1;
                        for (class_117 function : lootFunctions = ((LeafEntryAccessor)itemEntry).getFunctions()) {
                            class_44 constant;
                            class_141 setCount;
                            class_5658 number;
                            if (!(function instanceof class_141) || !((number = ((SetCountLootFunctionAccessor)(setCount = (class_141)function)).getCountRange()) instanceof class_5662)) continue;
                            class_5662 uniform = (class_5662)number;
                            class_5658 class_56582 = ((UniformLootNumberProviderAccessor)uniform).getMin();
                            if (class_56582 instanceof class_44) {
                                constant = (class_44)class_56582;
                                min = (int)((ConstantLootNumberProviderAccessor)constant).getValue();
                            }
                            if (!((class_56582 = ((UniformLootNumberProviderAccessor)uniform).getMax()) instanceof class_44)) continue;
                            constant = (class_44)class_56582;
                            max = (int)((ConstantLootNumberProviderAccessor)constant).getValue();
                        }
                        if (max < min) {
                            max = min;
                        }
                        this.register(blockItem, outputItem, min, max);
                        return new InspectedLootTable(blockItem, outputItem);
                    }
                    if (!isRawOre) continue;
                    return new InspectedLootTable(blockItem, outputItem);
                }
            }
        }
        return null;
    }

    private void register(class_1792 inputVariant, class_1792 outputItem, int min, int max) {
        if (this.blockCrushingRecipe != null) {
            this.basicInputToEntry.put(ItemVariant.of((class_1935)inputVariant), this.create(inputVariant, outputItem, this.blockCrushingRecipe, min, max));
        }
        if (this.advancedBlockCrushingRecipe != null) {
            this.advancedInputToEntry.put(ItemVariant.of((class_1935)inputVariant), this.create(inputVariant, outputItem, this.advancedBlockCrushingRecipe, min, max));
        }
        OreDustRegistry.Entry crushed = OreDustRegistry.CRUSHED_ORE.get(outputItem);
        OreDustRegistry.Entry dust = OreDustRegistry.ORE_DUST.get(outputItem);
        BallMillRecipeGenerator.INSTANCE.add(outputItem.method_40131().method_40237().method_29177().toString().replace(':', '_') + "_ore_dust", RecipeInputs.of(crushed.variant(), 1L), dust.variant());
    }

    private Entry create(class_1792 inputItem, class_1792 outputItem, BlockCrushingRecipe recipe, int min, int max) {
        min = (int)Math.max(recipe.getBaseAmount(), (long)min);
        max = (int)Math.max(recipe.getBaseAmount(), (long)max);
        int extraAmount = (int)recipe.getExtraAmount();
        ItemVariant outputVariant = OreDustRegistry.CRUSHED_ORE.get(outputItem).variant();
        RegistryRecipeInput<class_1792> input = RecipeInputs.of(inputItem, 1L);
        RecipeOutputImpl<class_1792> output = new RecipeOutputImpl<class_1792>(outputVariant.getItem(), min, max, 1.0f, Ingredients.ITEM, outputVariant.getNbt());
        RecipeOutputImpl<class_1792> extra = new RecipeOutputImpl<class_1792>(outputVariant.getItem(), extraAmount, extraAmount, recipe.getChance(), Ingredients.ITEM, outputVariant.getNbt());
        return new Entry(input, output, extra);
    }

    public Collection<Entry> getBasicEntries() {
        return this.basicInputToEntry.values();
    }

    public Collection<Entry> getAdvancedEntries() {
        return this.advancedInputToEntry.values();
    }

    private static void sync(MinecraftServer server, @NotNull Set<class_3222> players) {
        for (class_3222 player : players) {
            SYNC.emitter((class_1657)player).accept(new SyncData(BlockCrushingRegistry.INSTANCE.basicInputToEntry, BlockCrushingRegistry.INSTANCE.advancedInputToEntry));
        }
    }

    private record SyncData(Map<ItemVariant, Entry> basicInputToEntry, Map<ItemVariant, Entry> advancedInputToEntry) {
        public static final ParamCodec<SyncData> PARAM_CODEC = ParamCodec.of(SyncData.class, SyncData::write, SyncData::read);

        public static SyncData read(class_2540 buf) {
            SyncData data = new SyncData(new HashMap<ItemVariant, Entry>(), new HashMap<ItemVariant, Entry>());
            PacketBufUtil.readMap(buf, data.basicInputToEntry::put, ItemVariant::fromPacket, Entry::read);
            PacketBufUtil.readMap(buf, data.advancedInputToEntry::put, ItemVariant::fromPacket, Entry::read);
            return data;
        }

        private void write(class_2540 buf) {
            PacketBufUtil.writeMap(buf, this.basicInputToEntry, TransferVariant::toPacket, Entry::write);
            PacketBufUtil.writeMap(buf, this.advancedInputToEntry, TransferVariant::toPacket, Entry::write);
        }
    }

    public record Entry(RegistryRecipeInput<class_1792> input, RecipeOutput<class_1792> output, RecipeOutput<class_1792> extra) {
        public static Entry read(class_2540 buf) {
            RegistryRecipeInput<class_1792> input = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_1792> output = RecipeOutputImpl.read(class_7923.field_41178, buf);
            RecipeOutputImpl<class_1792> extra = RecipeOutputImpl.read(class_7923.field_41178, buf);
            return new Entry(input, output, extra);
        }

        public void write(class_2540 buf) {
            this.input.write(buf);
            this.output.write(buf);
            this.extra.write(buf);
        }
    }

    public record InspectedLootTable(class_1792 oreBlockItem, class_1792 rawOre) {
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void init() {
            SYNC.receiverHandler(EnvType.CLIENT, (player, buf, responseSender) -> data -> INSTANCE.read(class_310.method_1551().field_1687.method_8433(), (SyncData)data));
        }
    }
}

