/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.live_machine.metrics;

import com.neep.meatlib.api.network.ParamCodec;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.LivingMachineCols;
import com.neep.neepmeat.api.live_machine.metrics.FloatDataBuffer;
import com.neep.neepmeat.api.live_machine.metrics.LongDataBuffer;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public class DataLog {
    private long timeStart = -1L;
    private final LongDataBuffer time;
    private final FloatDataBuffer efficiency;
    private final FloatDataBuffer health;
    private final int sampleInterval;
    private final int capacity;
    public static final ParamCodec<DataView> PARAM_CODEC = ParamCodec.of(DataView.class, DataView::write, DataView::read);
    private static final List<ObjectIntPair<class_2561>> LEGEND = List.of(ObjectIntPair.of((Object)NeepMeat.translationKey("screen", "living_machine.efficiency"), (int)LivingMachineCols.EFFICIENCY), ObjectIntPair.of((Object)NeepMeat.translationKey("screen", "living_machine.health"), (int)LivingMachineCols.HEALTH));

    public DataLog(int capacity, int sampleInterval) {
        this.capacity = capacity;
        this.sampleInterval = sampleInterval;
        this.time = new LongDataBuffer(capacity);
        this.efficiency = new FloatDataBuffer(capacity);
        this.health = new FloatDataBuffer(capacity);
    }

    public void log(long time, LivingMachineBlockEntity be) {
        if (be.getAge() % (long)this.sampleInterval != 0L) {
            return;
        }
        if (this.timeStart == -1L) {
            this.timeStart = time;
        }
        this.time.enqueueCircular(time -= this.timeStart);
        this.efficiency.enqueueCircular(be.getEfficiency());
        this.health.enqueueCircular(be.getHealth());
    }

    public DataView asView() {
        return new DataView(this.capacity, this.efficiency.size(), this.time.encode(), this.efficiency.toDoubleArray(), this.health.toDoubleArray());
    }

    public record DataView(int capacity, int size, long[] time, double[] efficiency, double[] health) {
        public static final DataView EMPTY = new DataView(0, 0, new long[0], new double[0], new double[0]);

        public List<ObjectIntPair<class_2561>> getLegend() {
            return LEGEND;
        }

        public void write(class_2540 buf) {
            buf.writeInt(this.capacity);
            buf.writeInt(this.efficiency.length);
            buf.method_10789(this.time);
            buf.method_10806(Arrays.stream(this.efficiency).mapToInt(d -> Float.floatToIntBits((float)d)).toArray());
            buf.method_10806(Arrays.stream(this.health).mapToInt(d -> Float.floatToIntBits((float)d)).toArray());
        }

        public static DataView read(class_2540 buf) {
            int capacity = buf.readInt();
            int size = buf.readInt();
            long[] time = buf.method_33134();
            double[] efficiency = Arrays.stream(buf.method_10787()).mapToDouble(Float::intBitsToFloat).toArray();
            double[] health = Arrays.stream(buf.method_10787()).mapToDouble(Float::intBitsToFloat).toArray();
            return new DataView(capacity, size, time, efficiency, health);
        }
    }
}

