/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.live_machine;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentHolder;
import com.neep.neepmeat.api.live_machine.ComponentMap;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.DegradationManager;
import com.neep.neepmeat.api.live_machine.LivingMachineBlock;
import com.neep.neepmeat.api.live_machine.LivingMachineComponent;
import com.neep.neepmeat.api.live_machine.LivingMachineStructure;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.api.live_machine.StructureProperty;
import com.neep.neepmeat.api.live_machine.metrics.DataLog;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.entity.MachineWormEntity;
import com.neep.neepmeat.init.NMEntities;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.Processes;
import com.neep.neepmeat.machine.live_machine.block.TestLivingMachineBlock;
import com.neep.neepmeat.machine.live_machine.block.entity.IntegrationPortBlockEntity;
import com.neep.neepmeat.machine.live_machine.block.entity.MotorPortBlockEntity;
import com.neep.neepmeat.machine.live_machine.component.ItemOutputComponent;
import com.neep.neepmeat.machine.live_machine.component.PoweredComponent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LivingMachineBlockEntity
extends SyncableBlockEntity
implements ComponentHolder {
    public static Codec<EnumMap<StructureProperty, Float>> PROPERTIES_CODEC = Codec.unboundedMap(StructureProperty.CODEC, (Codec)Codec.FLOAT).xmap(map -> map.isEmpty() ? new EnumMap(StructureProperty.class) : new EnumMap(map), Function.identity());
    private final class_5819 random = class_5819.method_43047();
    protected List<DamageableStructureEntry> damageableStructures = new ObjectArrayList();
    protected List<LivingMachineStructure> structures = new ObjectArrayList();
    private ComponentMap componentMap = new ComponentMap();
    private EnumMap<StructureProperty, Float> properties = new EnumMap(StructureProperty.class);
    protected DegradationManager degradationManager = new DegradationManager(this::degradationRate, class_5819.method_43047(), this::updateBlockState);
    private final float rateMultiplier = 1.0f;
    private final DataLog dataLog;
    protected long age = 0L;
    protected int updateInterval = 80;
    protected int maxSize;
    protected float power;
    protected float repairAmount;
    protected boolean updateProcess;
    @Nullable
    private Process process;
    private Storage<ItemVariant> combinedItemInput;
    private Storage<ItemVariant> combinedItemOutput;
    private Storage<FluidVariant> combinedFluidInput;
    private Storage<FluidVariant> combinedFluidOutput;
    public int inputSequence;
    private int numStructures;
    private int numComponents;
    private final List<class_2960> components;
    private class_2561 processName;
    private List<class_2561> problems;

    public LivingMachineBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.maxSize = (Integer)NeepMeat.CONFIG.livingMachines.maxBlocks.getRealValue();
        this.updateProcess = true;
        this.combinedItemInput = Storage.empty();
        this.combinedItemOutput = Storage.empty();
        this.combinedFluidInput = Storage.empty();
        this.combinedFluidOutput = Storage.empty();
        this.components = new ArrayList<class_2960>();
        this.processName = Process.NO_PROCESS;
        this.problems = List.of();
        this.dataLog = new DataLog(500, 40);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.age = nbt.method_10537("age");
        this.properties = PROPERTIES_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("properties")).result().orElseGet(() -> new EnumMap(StructureProperty.class));
        this.power = nbt.method_10583("power");
        this.degradationManager.readNbt(nbt);
        this.numStructures = nbt.method_10550("num_structures");
        this.numComponents = nbt.method_10550("num_components");
        this.processName = class_2561.method_30163((String)nbt.method_10558("process_name"));
        this.repairAmount = nbt.method_10583("repair");
        this.components.clear();
        class_2499 list = nbt.method_10554("components", 8);
        for (int i = 0; i < list.size(); ++i) {
            this.components.add(class_2960.method_12829((String)list.method_10608(i)));
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544("age", this.age);
        PROPERTIES_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.properties).get().ifLeft(r -> nbt.method_10566("properties", r));
        nbt.method_10548("power", this.power);
        this.degradationManager.writeNbt(nbt);
        nbt.method_10569("num_structures", this.structures.size());
        nbt.method_10569("num_components", this.getNumComponents());
        nbt.method_10582("process_name", this.getProcess().getString());
        nbt.method_10548("repair", this.repairAmount);
        class_2499 componentList = new class_2499();
        for (int i = this.componentMap.nextSetBit(0); i != -1 && i < this.componentMap.length(); ++i) {
            ComponentType type = (ComponentType)ComponentType.ID_TO_TYPE.get(i = this.componentMap.nextSetBit(i));
            class_2960 id = ComponentType.REGISTRY.method_10221((Object)type);
            if (id == null) continue;
            componentList.add((Object)class_2519.method_23256((String)id.toString()));
        }
        nbt.method_10566("components", (class_2520)componentList);
    }

    protected void tickDegradation() {
        float selfRepair;
        this.repairAmount = 0.0f;
        if (this.getProgressIncrement() == 0.0f) {
            double repairPerDroplet = 3.0864198379276786E-6;
            long maxConsume = 30L;
            long consumePerTick = Math.min((long)class_3532.method_15384((double)((double)this.degradationManager.getDegradation() / repairPerDroplet)), maxConsume);
            AtomicLong satisfied = new AtomicLong();
            this.withComponents(LivingMachineComponents.INTEGRATION_PORT).ifPresent(w -> {
                try (Transaction transaction = Transaction.openOuter();){
                    for (IntegrationPortBlockEntity port : w.t1()) {
                        if (satisfied.get() >= consumePerTick) break;
                        satisfied.addAndGet(port.getFluidStorage(null).extract((TransferVariant)FluidVariant.of((class_3611)NMFluids.STILL_WORK_FLUID), consumePerTick - satisfied.get(), (TransactionContext)transaction));
                    }
                    transaction.commit();
                }
            });
            if (satisfied.get() > 0L && satisfied.get() >= consumePerTick) {
                this.repairAmount += (float)(1.0 * repairPerDroplet * (double)satisfied.get());
            }
        }
        if ((selfRepair = this.getSelfRepair()) > 0.0f) {
            this.repairAmount += 1.0f * selfRepair;
        }
        this.degradationManager.tick();
    }

    private void updateBlockState() {
        TestLivingMachineBlock.Status status = TestLivingMachineBlock.Status.INVALID_STRUCTURE;
        if (this.process != null) {
            status = TestLivingMachineBlock.Status.ACTIVE;
        }
        if (this.getHealth() <= 0.0f) {
            status = TestLivingMachineBlock.Status.BROKEN;
        }
        this.method_10997().method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(TestLivingMachineBlock.STATUS, (Comparable)((Object)status)));
    }

    public void serverTick() {
        if (this.age % (long)this.updateInterval == 0L) {
            this.updateStructure();
            this.sync();
            if (this.process != null) {
                this.problems = this.process.getProblems(this);
            }
        }
        if (this.updateProcess) {
            this.updateSpecialStorage();
            Process newProcess = Processes.getInstance().getFirstMatch(this.componentMap.bits);
            if (newProcess != this.process) {
                if (this.process != null) {
                    this.process.onStop(this);
                }
                this.process = newProcess;
                if (newProcess != null) {
                    newProcess.onStart(this);
                }
            }
            this.updateProcess = false;
            this.updateBlockState();
        }
        ++this.age;
        this.tickDegradation();
        Collection<MotorPortBlockEntity> motors = this.getComponent(LivingMachineComponents.MOTOR_PORT);
        float nextPower = 0.0f;
        if (!motors.isEmpty()) {
            for (MotorPortBlockEntity motor : motors) {
                nextPower = Math.max(nextPower, motor.getPower());
            }
        } else {
            nextPower = 0.0f;
        }
        this.power = nextPower;
        for (int i = this.componentMap.nextSetBit(0); i != -1 && i < this.componentMap.length(); ++i) {
            i = this.componentMap.nextSetBit(i);
            Iterator it = this.componentMap.get(i).iterator();
            while (it.hasNext()) {
                LivingMachineComponent component = (LivingMachineComponent)it.next();
                if (component.componentRemoved()) {
                    it.remove();
                    this.removeComponent(component);
                    this.sync();
                    this.updateProcess = true;
                    continue;
                }
                if (!(component instanceof PoweredComponent)) continue;
                PoweredComponent powered = (PoweredComponent)component;
                powered.setProgressIncrement(this.getProgressIncrement());
            }
        }
        if (this.process != null) {
            this.process.serverTick(this);
        }
        this.dataLog.log(this.method_10997().method_8510(), this);
        if (this.getHealth() <= 0.0f) {
            this.becomeEntity();
        }
    }

    protected void updateStructure() {
        ObjectArrayList newStructures = new ObjectArrayList();
        ObjectArrayList newDamageable = new ObjectArrayList();
        ComponentMap newComponentMap = new ComponentMap();
        this.search(this.method_11016(), (List<LivingMachineStructure>)newStructures, (List<DamageableStructureEntry>)newDamageable, newComponentMap);
        this.structures = newStructures;
        this.damageableStructures = newDamageable;
        this.processComponents(newComponentMap);
        this.componentMap = newComponentMap;
        this.processStructure();
        this.updateSpecialStorage();
        this.updateProcess = true;
    }

    protected void processComponents(ComponentMap newComponentMap) {
        for (int i = this.componentMap.nextSetBit(0); i != -1 && i < this.componentMap.length(); ++i) {
            i = this.componentMap.nextSetBit(i);
            Collection oldSet = this.componentMap.get(i);
            if (newComponentMap.has(i)) {
                Collection newSet = newComponentMap.get(i);
                for (LivingMachineComponent oldComponent : oldSet) {
                    if (newSet.contains(oldComponent)) continue;
                    oldComponent.shutdown();
                }
                continue;
            }
            for (LivingMachineComponent oldComponent : oldSet) {
                oldComponent.shutdown();
            }
        }
    }

    protected void processStructure() {
        EnumMap present = new EnumMap(StructureProperty.class);
        for (LivingMachineStructure structure : this.structures) {
            structure.getProperties().forEach((property, value) -> {
                if (value.function().average()) {
                    present.compute((StructureProperty)property, (p, v) -> v == null ? 1 : v + 1);
                }
            });
        }
        this.properties.clear();
        for (LivingMachineStructure structure : this.structures) {
            structure.getProperties().forEach((property, entry) -> {
                int numberPresent = present.getOrDefault(property, 1);
                this.properties.compute((StructureProperty)property, (p, prev) -> {
                    if (prev == null) {
                        prev = Float.valueOf(p.defaultValue());
                    }
                    return Float.valueOf(entry.apply(prev.floatValue(), numberPresent));
                });
            });
        }
    }

    private void updateSpecialStorage() {
        this.combinedItemInput = new CombinedStorage(this.getComponent(LivingMachineComponents.ITEM_INPUT).stream().map(l -> l.getStorage(null)).toList());
        this.combinedItemOutput = new StorageDelegate(this.getComponent(LivingMachineComponents.ITEM_OUTPUT).stream().map(ItemOutputComponent::getInternalStorage).toList());
        this.combinedFluidInput = new CombinedStorage(Streams.concat((Stream[])new Stream[]{this.getComponent(LivingMachineComponents.FLUID_INPUT).stream(), this.getComponent(LivingMachineComponents.STOMACH).stream()}).map(l -> l.getStorage(null)).toList());
        this.combinedFluidOutput = new CombinedStorage(this.getComponent(LivingMachineComponents.FLUID_OUTPUT).stream().map(l -> l.getStorage(null)).toList());
    }

    protected float getProperty(StructureProperty property) {
        return this.properties.computeIfAbsent(property, StructureProperty::defaultValue).floatValue();
    }

    @Override
    public <T extends LivingMachineComponent> Collection<T> getComponent(ComponentType<T> type) {
        return this.componentMap.get(type.getBitIdx());
    }

    private void removeComponent(LivingMachineComponent component) {
        this.componentMap.onRemove(component);
    }

    protected void clearComponents() {
        for (int i = this.componentMap.nextSetBit(0); i != -1 && i < this.componentMap.length(); ++i) {
            i = this.componentMap.nextSetBit(i);
            this.componentMap.clear(i, c -> c.setController(null));
        }
    }

    protected void search(class_2338 start, List<LivingMachineStructure> structures, List<DamageableStructureEntry> damageableStructures, ComponentMap newComponentMap) {
        HashSet visited = Sets.newHashSet();
        ArrayDeque queue = Queues.newArrayDeque();
        visited.add(this.field_11867);
        queue.add(start);
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            class_2338.class_2339 mutable = current.method_25503();
            for (class_2350 direction : class_2350.values()) {
                mutable.method_25505((class_2382)current, direction);
                if (visited.contains(mutable)) continue;
                visited.add(mutable.method_10062());
                class_2680 nextState = this.field_11863.method_8320((class_2338)mutable);
                if (nextState.method_26215()) continue;
                if (structures.size() >= this.maxSize) {
                    return;
                }
                if (nextState.method_26204() instanceof LivingMachineBlock) {
                    structures.clear();
                    damageableStructures.clear();
                    this.clearComponents();
                    return;
                }
                class_2248 class_22482 = nextState.method_26204();
                if (class_22482 instanceof LivingMachineStructure) {
                    LivingMachineStructure structure = (LivingMachineStructure)class_22482;
                    structures.add(structure);
                    if (structure.canOpen()) {
                        damageableStructures.add(new DamageableStructureEntry(structure, mutable.method_10062()));
                    }
                    queue.add(mutable.method_10062());
                    continue;
                }
                LivingMachineComponent component = (LivingMachineComponent)LivingMachineComponent.LOOKUP.find(this.field_11863, (class_2338)mutable, null);
                if (component == null) continue;
                component.setController(this.field_11867);
                newComponentMap.add(component);
                queue.add(mutable.method_10062());
            }
        }
    }

    public float getProgressIncrement() {
        return this.power * this.getEfficiency();
    }

    public float getEfficiency() {
        return (float)(1.0 - Math.pow(this.degradationManager.getDegradation(), 4.0));
    }

    public float getSelfRepair() {
        return this.getProperty(StructureProperty.SELF_REPAIR);
    }

    public float getRatedPower() {
        return this.getProperty(StructureProperty.MAX_POWER) / (float)PowerUtils.referencePower();
    }

    public double degradationRate(double degradation) {
        double rate = -this.repairAmount;
        float rated = this.getRatedPower();
        if (this.power <= 0.0f && rate >= 0.0) {
            return 0.0;
        }
        if (rated <= 0.0f) {
            return 3.4028234663852886E38;
        }
        if ((double)this.power <= (double)rated * 0.75) {
            return rate;
        }
        rate = this.power > rated * 2.0f ? (rate += (double)(1.0f * (1.0E-5f * this.power / rated))) : (this.power > rated ? (rate += (double)(1.0f * (7.0E-6f * this.power / rated))) : (rate += (double)3.0E-6f));
        return rate;
    }

    public float getPower() {
        return this.power;
    }

    public double getRulHours() {
        return (double)this.degradationManager.estimateRul() / 72000.0;
    }

    public long getRulSecs() {
        long ticks = this.degradationManager.estimateRul();
        if (ticks == -1L) {
            return -1L;
        }
        return ticks / 20L;
    }

    public float getCurrentDegradationRate() {
        return (float)this.degradationRate(this.degradationManager.getDegradation());
    }

    public void onBlockRemoved() {
        if (this.process != null) {
            this.process.onStop(this);
        }
        for (int i = this.componentMap.nextSetBit(0); i != -1 && i < this.componentMap.length(); ++i) {
            i = this.componentMap.nextSetBit(i);
            this.componentMap.clear(i, LivingMachineComponent::shutdown);
        }
    }

    protected void becomeEntity() {
        MachineWormEntity entity = (MachineWormEntity)NMEntities.MACHINE_WORM.method_5883(this.field_11863);
        if (entity != null) {
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
            class_243 ePos = class_243.method_26410((class_2382)this.field_11867, (double)0.05);
            entity.method_5814(ePos.field_1352, ePos.field_1351, ePos.field_1350);
            entity.method_23327(ePos.field_1352, ePos.field_1351, ePos.field_1350);
            float yaw = ((class_2350)this.method_11010().method_11654((class_2769)TestLivingMachineBlock.FACING)).method_10144();
            entity.method_36456(yaw);
            entity.method_5847(yaw);
            this.field_11863.method_8649((class_1297)entity);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_15152, class_3419.field_15245, 1.0f, 1.3f);
        }
    }

    public class_5819 getRandom() {
        return this.random;
    }

    public DataLog getDataLog() {
        return this.dataLog;
    }

    public long getAge() {
        return this.age;
    }

    public DegradationManager getDegradationManager() {
        return this.degradationManager;
    }

    public float getHealth() {
        return 1.0f - this.degradationManager.getDegradation();
    }

    public int getNumStructures() {
        if (!this.field_11863.method_8608()) {
            return this.structures.size();
        }
        return this.numStructures;
    }

    public int getNumComponents() {
        if (!this.field_11863.method_8608()) {
            int count = 0;
            for (Set<LivingMachineComponent> set : this.componentMap.componentMap) {
                if (set == null) continue;
                count += set.size();
            }
            return count;
        }
        return this.numComponents;
    }

    public class_2561 getProcess() {
        if (!this.field_11863.method_8608()) {
            return this.process != null ? this.process.getName() : Process.NO_PROCESS;
        }
        return this.processName != null ? this.processName : Process.NO_PROCESS;
    }

    public List<class_2960> getDisplayComponents() {
        return this.components;
    }

    public Storage<ItemVariant> getCombinedItemInput() {
        return this.combinedItemInput;
    }

    public Storage<ItemVariant> getCombinedItemOutput() {
        return this.combinedItemOutput;
    }

    public Storage<FluidVariant> getCombinedFluidInput() {
        return this.combinedFluidInput;
    }

    public Storage<FluidVariant> getCombinedFluidOutput() {
        return this.combinedFluidOutput;
    }

    public List<class_2561> getProblems() {
        return this.problems;
    }

    private static class StorageDelegate
    implements Storage<ItemVariant> {
        private final Storage<ItemVariant> storage;

        private StorageDelegate(List<Storage<ItemVariant>> storages) {
            this.storage = new CombinedStorage(storages);
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return this.storage.insert((Object)resource, maxAmount, transaction);
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return this.storage.extract((Object)resource, maxAmount, transaction);
        }

        @NotNull
        public Iterator<StorageView<ItemVariant>> iterator() {
            return this.storage.iterator();
        }
    }

    protected record DamageableStructureEntry(LivingMachineStructure structure, class_2338 pos) {
    }
}

