/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.live_machine;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineComponent;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class ComponentMap {
    public final Set<LivingMachineComponent>[] componentMap = (Set[])Array.newInstance(Set.class, ComponentType.Simple.NEXT_ID);
    public final BitSet bits = new BitSet();

    protected void add(LivingMachineComponent component) {
        int idx = component.getComponentType().getBitIdx();
        if (this.componentMap[idx] == null) {
            this.componentMap[idx] = new HashSet<LivingMachineComponent>();
        }
        this.bits.set(idx);
        this.componentMap[idx].add(component);
    }

    public int length() {
        return this.bits.length();
    }

    public int nextSetBit(int i) {
        return this.bits.nextSetBit(i);
    }

    public <T> Collection<T> get(int idx) {
        if (!this.bits.get(idx)) {
            return Collections.emptySet();
        }
        return this.componentMap[idx];
    }

    public void onRemove(LivingMachineComponent component) {
        int idx = component.getComponentType().getBitIdx();
        if (!this.bits.get(idx)) {
            return;
        }
        if (this.componentMap[idx] == null || this.componentMap[idx].isEmpty()) {
            this.bits.clear(idx);
        }
    }

    public void clear(int idx, Consumer<LivingMachineComponent> handler) {
        Set<LivingMachineComponent> set = this.componentMap[idx];
        if (set == null) {
            NeepMeat.LOGGER.error("Something has gone horribly wrong");
        } else {
            this.componentMap[idx].forEach(handler);
            this.componentMap[idx].clear();
        }
    }

    public boolean has(int i) {
        return this.bits.get(i);
    }
}

