/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.block;

import com.neep.neepmeat.block.WashableFire;
import com.neep.neepmeat.init.NMFluids;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5955;
import org.jetbrains.annotations.Nullable;

public interface PressureWashable {
    public static final Map<class_2248, PressureWashable> FALLBACK = new IdentityHashMap<class_2248, PressureWashable>();
    public static final PressureWashable VINE = new Simple(43520);
    public static final PressureWashable GLOW_LICHEN = new Simple(9879470);
    public static final PressureWashable FROGSPAWN = new Simple(9930623);
    public static final PressureWashable SCULK_VEIN = new Simple(228763);
    public static final PressureWashable GRASS_BLOCK = new ToState(() -> ((class_2248)class_2246.field_10566).method_9564(), 228763);

    public static void registerFallback(class_2248 block, PressureWashable washable) {
        FALLBACK.put(block, washable);
    }

    @Nullable
    public static PressureWashable get(class_2680 state) {
        if (state.method_26215()) {
            return null;
        }
        class_2248 block = state.method_26204();
        if (block instanceof PressureWashable) {
            PressureWashable washable = (PressureWashable)block;
            return washable;
        }
        PressureWashable fallback = FALLBACK.get(block);
        if (fallback != null) {
            return fallback;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_5955) {
            class_5955 oxidizable = (class_5955)class_22482;
            return new Oxidisable(oxidizable);
        }
        class_22482 = state.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 cropBlock = (class_2302)class_22482;
            return new Crop(cropBlock);
        }
        return null;
    }

    public static void initDefaults() {
        PressureWashable.registerFallback(class_2246.field_10036, new WashableFire());
        PressureWashable.registerFallback(class_2246.field_37569, SCULK_VEIN);
        PressureWashable.registerFallback(class_2246.field_10597, VINE);
        PressureWashable.registerFallback(class_2246.field_28411, GLOW_LICHEN);
        PressureWashable.registerFallback(class_2246.field_37575, FROGSPAWN);
        PressureWashable.registerFallback(class_2246.field_10588, new Simple(34816));
    }

    public int wash(class_1937 var1, class_2338 var2, class_2680 var3, class_243 var4, int var5, FluidVariant var6);

    default public int tint() {
        return -1;
    }

    public record Oxidisable(class_5955 oxidizable) implements PressureWashable
    {
        @Override
        public int wash(class_1937 world, class_2338 pos, class_2680 state, class_243 velocity, int power, FluidVariant fluidVariant) {
            if (power > 0) {
                Optional result;
                if (fluidVariant.isOf((Object)NMFluids.STILL_PATINA_TREATMENT)) {
                    Optional result2 = this.oxidizable.method_31639(state);
                    if (result2.isPresent()) {
                        world.method_8501(pos, (class_2680)result2.get());
                        return 1;
                    }
                } else if (FluidVariantAttributes.getTemperature((FluidVariant)fluidVariant) >= 1300 && (result = class_5955.method_34735((class_2680)state)).isPresent()) {
                    world.method_8501(pos, (class_2680)result.get());
                    return 1;
                }
            }
            return 0;
        }
    }

    public record Crop(class_2302 block) implements PressureWashable
    {
        @Override
        public int wash(class_1937 world, class_2338 pos, class_2680 state, class_243 velocity, int power, FluidVariant fluidVariant) {
            if (power > 1 && fluidVariant.isOf(NMFluids.COMPRESSED_AIR.still())) {
                world.method_22352(pos, true);
                return 1;
            }
            return 0;
        }

        @Override
        public int tint() {
            return -1;
        }
    }

    public record Simple(int tint) implements PressureWashable
    {
        @Override
        public int wash(class_1937 world, class_2338 pos, class_2680 state, class_243 velocity, int power, FluidVariant fluidVariant) {
            if (power > 0) {
                world.method_22352(pos, true);
                return 1;
            }
            return 0;
        }
    }

    public record ToState(Supplier<class_2680> stateSupplier, int tint) implements PressureWashable
    {
        @Override
        public int wash(class_1937 world, class_2338 pos, class_2680 state, class_243 velocity, int power, FluidVariant fluidVariant) {
            if (power > 0) {
                world.method_8501(pos, this.stateSupplier.get());
                return 1;
            }
            return 0;
        }
    }
}

