/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api;

import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_2350;
import net.minecraft.class_2960;

public interface FluidPump {
    public static final BlockApiLookup<FluidPump, class_2350> SIDED = BlockApiLookup.get((class_2960)new class_2960("neepmeat", "sided_fluid_pump"), FluidPump.class, class_2350.class);

    public static FluidPump of(final float flow, final boolean isStorage) {
        return new FluidPump(){

            @Override
            public float getFlow() {
                return this.getMode().isDriving() ? flow : 0.0f;
            }

            @Override
            public AcceptorModes getMode() {
                return AcceptorModes.byFlow(flow);
            }

            @Override
            public boolean isStorage() {
                return isStorage;
            }
        };
    }

    public static FluidPump of(final float flow, final Supplier<AcceptorModes> supplier) {
        return new FluidPump(){

            @Override
            public float getFlow() {
                return this.getMode().isDriving() ? flow : 0.0f;
            }

            @Override
            public AcceptorModes getMode() {
                return (AcceptorModes)((Object)supplier.get());
            }

            @Override
            public boolean isStorage() {
                return true;
            }
        };
    }

    public static FluidPump of(final float flow, final Supplier<AcceptorModes> supplier, final float pumpHeightMagnitude) {
        return new FluidPump(){

            @Override
            public float getFlow() {
                return this.getMode().isDriving() ? flow : 0.0f;
            }

            @Override
            public AcceptorModes getMode() {
                return (AcceptorModes)((Object)supplier.get());
            }

            @Override
            public boolean isStorage() {
                return true;
            }

            @Override
            public float getPumpHeight() {
                return this.getMode().getFlow() * pumpHeightMagnitude;
            }
        };
    }

    public float getFlow();

    public AcceptorModes getMode();

    public boolean isStorage();

    default public float getPumpHeight() {
        return this.getMode().getFlow() * 20.0f;
    }
}

