/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.client.instance;

import com.neep.meatlib.client.flw.MeatModels;
import com.neep.neepbus.block.SlantedSliderBlock;
import com.neep.neepbus.block.SliderBlock;
import com.neep.neepbus.block.entity.SliderBlockEntity;
import com.neep.neepmeat.client.NMExtraModels;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class LinearLeverVisual
extends AbstractBlockEntityVisual<SliderBlockEntity>
implements SimpleDynamicVisual {
    private float lerpOffset = 0.0f;
    private final TransformedInstance handle;

    public LinearLeverVisual(VisualizationContext ctx, SliderBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
        this.handle = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.LINEAR_LEVER_HANDLE)).createInstance();
    }

    public void _delete() {
        this.handle.delete();
    }

    public void beginFrame(DynamicVisual.Context context) {
        float f = 0.625f * LinearLeverVisual.clamp((((SliderBlockEntity)this.blockEntity).getValue() - ((SliderBlockEntity)this.blockEntity).getMinValue()) / (((SliderBlockEntity)this.blockEntity).getMaxValue() - ((SliderBlockEntity)this.blockEntity).getMinValue()), 0.0f, 1.0f);
        this.lerpOffset = class_3532.method_16439((float)0.4f, (float)this.lerpOffset, (float)f);
        if (this.blockState.method_26204() instanceof SliderBlock) {
            Quaternionf facing = this.rotateThing((class_2350)this.blockState.method_11654((class_2769)class_2341.field_11177), (class_2738)this.blockState.method_11654((class_2769)class_2341.field_11007));
            ((TransformedInstance)((TransformedInstance)this.handle.setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotate((Quaternionfc)facing).translate(0.0f, 0.0f, this.lerpOffset).uncenter();
        } else if (this.blockState.method_26204() instanceof SlantedSliderBlock) {
            Quaternionf facing = this.rotateSlanted((class_2350)this.blockState.method_11654((class_2769)SlantedSliderBlock.field_11177), (SlantedSliderBlock.Attachment)((Object)this.blockState.method_11654(SlantedSliderBlock.FACE)));
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.handle.setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotate((Quaternionfc)facing).uncenter()).translate(0.0f, 0.0625f, 0.0f).rotateX(-0.7853982f).translate(0.0f, 0.0f, 0.25f).translate(0.0f, 0.0f, this.lerpOffset);
        }
        this.handle.setChanged();
    }

    public void updateLight(float v) {
        this.relight(this.pos, new FlatLit[]{this.handle});
    }

    private Quaternionf rotateThing(class_2350 horFacing, class_2738 face) {
        if (face == class_2738.field_12471) {
            return switch (horFacing) {
                case class_2350.field_11043 -> LinearLeverVisual.euler(-90.0f, 0.0f);
                case class_2350.field_11035 -> LinearLeverVisual.euler(-90.0f, 180.0f);
                case class_2350.field_11034 -> LinearLeverVisual.euler(-90.0f, -90.0f);
                default -> LinearLeverVisual.euler(-90.0f, 90.0f);
            };
        }
        if (face == class_2738.field_12475) {
            return switch (horFacing) {
                case class_2350.field_11043 -> class_7833.field_40716.rotationDegrees(180.0f);
                case class_2350.field_11035 -> new Quaternionf();
                case class_2350.field_11034 -> LinearLeverVisual.euler(0.0f, 90.0f);
                default -> LinearLeverVisual.euler(0.0f, -90.0f);
            };
        }
        return switch (horFacing) {
            case class_2350.field_11043 -> LinearLeverVisual.euler(180.0f, 0.0f);
            case class_2350.field_11035 -> LinearLeverVisual.euler(180.0f, 180.0f);
            case class_2350.field_11034 -> LinearLeverVisual.euler(180.0f, -90.0f);
            default -> LinearLeverVisual.euler(180.0f, 90.0f);
        };
    }

    private Quaternionf rotateSlanted(class_2350 horFacing, SlantedSliderBlock.Attachment face) {
        if (face == SlantedSliderBlock.Attachment.FLOOR) {
            return switch (horFacing) {
                case class_2350.field_11043 -> class_7833.field_40716.rotationDegrees(180.0f);
                case class_2350.field_11035 -> new Quaternionf();
                case class_2350.field_11034 -> LinearLeverVisual.euler(0.0f, 90.0f);
                default -> LinearLeverVisual.euler(0.0f, -90.0f);
            };
        }
        return switch (horFacing) {
            case class_2350.field_11043 -> LinearLeverVisual.euler(180.0f, 0.0f);
            case class_2350.field_11035 -> LinearLeverVisual.euler(180.0f, 180.0f);
            case class_2350.field_11034 -> LinearLeverVisual.euler(180.0f, -90.0f);
            default -> LinearLeverVisual.euler(180.0f, 90.0f);
        };
    }

    public static float clamp(float value, float min, float max) {
        if (Float.isNaN(value)) {
            return min;
        }
        return value < min ? min : Math.min(value, max);
    }

    private static Quaternionf euler(float xDeg, float yDeg) {
        return new Quaternionf().rotateZYX(0.0f, yDeg * ((float)Math.PI / 180), xDeg * ((float)Math.PI / 180));
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }
}

