/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.block.entity.PIDController;
import com.neep.neepbus.util.CachingSender;
import com.neep.neepbus.util.DirectReadPort;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.message.DataVariant;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class PIDControllerBlockEntity
extends SyncableBlockEntity
implements ConfigProvider,
PIDController {
    private final CachingSender sender = new CachingSender(() -> ((PIDControllerBlockEntity)this).method_10997(), this.method_11016());
    private final DirectReadPort outputPort = new DirectReadPort(new SimpleEntry("PID Output"), this::getOutput, this.sender::send);
    private final SimpleEntry setpointPort = new SimpleEntry("Setpoint");
    private final SimpleEntry measurement = new SimpleEntry("Measurement");
    private final NeepBusConfig config = NeepBusConfig.builder(this::sync).output(this.outputPort.entry(), this.outputPort).input(this.setpointPort, this::setSetPoint).input(this.measurement, this::setMeasured).build();
    private int dt = 2;
    protected float lastError;
    protected float integral;
    protected float kp = 1.0f;
    protected float ki = 0.0f;
    protected float kd = 0.0f;
    protected float windupLimit = 1.0f;
    protected float output;

    public PIDControllerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    private DataVariant getOutput() {
        return DataVariant.of(this.output);
    }

    private void setSetPoint(DataVariant i) {
    }

    private void setMeasured(DataVariant i) {
    }

    public void serverTick() {
        if (this.field_11863.method_8510() % (long)this.dt == 0L) {
            float measured = this.sender.read(this.measurement.getAddress()).floatValue();
            float setpoint = this.sender.read(this.setpointPort.getAddress()).floatValue();
            float error = setpoint - measured;
            this.integral = class_3532.method_15363((float)(this.integral + error * (float)this.dt), (float)(-this.windupLimit), (float)this.windupLimit);
            float derivative = (error - this.lastError) / (float)this.dt;
            this.output = this.kp * error + this.ki * this.integral + this.kd * derivative;
            this.outputPort.send();
            this.lastError = error;
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("config", (class_2520)this.config.writeNbt(new class_2487()));
        nbt.method_10569("dt", this.dt);
        nbt.method_10548("kp", this.kp);
        nbt.method_10548("ki", this.ki);
        nbt.method_10548("kd", this.kd);
        nbt.method_10548("windup_limit", this.windupLimit);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.config.readNbt(nbt.method_10562("config"));
        this.dt = nbt.method_10550("dt");
        this.kp = nbt.method_10583("kp");
        this.ki = nbt.method_10583("ki");
        this.kd = nbt.method_10583("kd");
        this.windupLimit = nbt.method_10583("windup_limit");
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    @Override
    public int getDt() {
        return this.dt;
    }

    @Override
    public void setDt(int dt) {
        this.dt = Math.max(1, dt);
    }

    @Override
    public void setKP(float kp) {
        this.kp = kp;
    }

    @Override
    public float getKP() {
        return this.kp;
    }

    @Override
    public void setKI(float ki) {
        this.ki = ki;
    }

    @Override
    public float getKI() {
        return this.ki;
    }

    @Override
    public void setKD(float kd) {
        this.kd = kd;
    }

    @Override
    public float getKD() {
        return this.kd;
    }

    @Override
    public void setWindupLimit(float windupLimit) {
        this.windupLimit = windupLimit;
    }

    @Override
    public float getWindupLimit() {
        return this.windupLimit;
    }

    @Override
    public void markBlockDirty() {
        this.sync();
    }

    public void invalidate() {
        this.sender.invalidate();
    }
}

