/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.mixin;

import com.mojang.datafixers.util.Either;
import com.neep.meatweapons.entity.HitOnCollideEntity;
import com.neep.meatweapons.entity.PlayerWeaponManager;
import com.neep.meatweapons.interfaces.MWPlayerEntity;
import com.neep.meatweapons.meatgun.module.HalberdModule;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3902;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1297
implements MWPlayerEntity,
HitOnCollideEntity {
    @Unique
    private int collideHitTicks;
    @Unique
    private float collideHitDamage;
    @Unique
    protected PlayerWeaponManager manager = new PlayerWeaponManager((class_1657)this);

    @Shadow
    public abstract Either<class_1657.class_1658, class_3902> method_7269(class_2338 var1);

    @Shadow
    public abstract void method_5650(class_1297.class_5529 var1);

    @Shadow
    public abstract boolean method_23668();

    public PlayerEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public PlayerWeaponManager meatweapons$getWeaponManager() {
        return this.manager;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    void onTick(CallbackInfo ci) {
        this.manager.tick();
        this.collideHitTicks = Math.max(0, this.collideHitTicks - 1);
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    void onDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.collideHitTicks > 0 && (source.method_49708(class_8111.field_42320) || source.method_49708(class_8111.field_42360))) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Override
    public void meatweapons$setActiveTicks(int ticks) {
        this.collideHitTicks = ticks;
    }

    @Override
    public void meatweapons$setDamage(float damage) {
        this.collideHitDamage = damage;
    }

    @Inject(method={"collideWithEntity"}, at={@At(value="HEAD")})
    private void onCollideWithEntity(class_1297 entity, CallbackInfo ci) {
        HalberdModule.onEntityCollide((class_1657)this, entity, this.collideHitTicks, this.collideHitDamage);
    }
}

