/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun.module;

import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.AbstractMeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import com.neep.meatweapons.meatgun.module.ModuleSlot;
import com.neep.meatweapons.meatgun.module.SimpleModuleSlot;
import com.neep.meatweapons.network.MWAttackC2SPacket;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class TripleCarouselModule
extends AbstractMeatgunModule {
    public float lerpAngle;
    private int rotateTicks = 5;
    private int selected = 0;
    private long rotateStartTime = 0L;

    public TripleCarouselModule(RootModuleHolder.Listener listener) {
        super(listener);
        TCSlot slot0 = new TCSlot(this.listener, 0);
        TCSlot slot1 = new TCSlot(this.listener, 1);
        TCSlot slot2 = new TCSlot(this.listener, 2);
        this.setSlots(List.of(slot0, slot1, slot2));
    }

    public TripleCarouselModule(RootModuleHolder.Listener listener, class_2487 nbt) {
        this(listener);
    }

    @Override
    public void trigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        if (!this.isRotating(world.method_8510())) {
            if (id == 2) {
                this.rotate(player);
            } else {
                ((ModuleSlot)this.slots.get(this.selected)).get().trigger(world, player, stack, id, pitch, yaw, handType, hand);
                this.rotate(player);
            }
        }
    }

    @Override
    public void tickTrigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        if (!this.isRotating(world.method_8510())) {
            if (id == 2) {
                this.rotate(player);
            } else {
                ((ModuleSlot)this.slots.get(this.selected)).get().tickTrigger(world, player, stack, id, pitch, yaw, handType, hand);
                this.rotate(player);
            }
        }
    }

    private void rotate(class_1657 player) {
        this.rotateStartTime = player.method_37908().method_8510();
        this.sync(player);
    }

    public boolean isRotating(long time) {
        return time < this.rotateStartTime + (long)this.rotateTicks;
    }

    @Override
    public void tick(class_1657 player) {
        super.tick(player);
        long time = player.method_37908().method_8510();
        if (!player.method_37908().method_8608()) {
            if (!this.isRotating(time) && time == this.rotateStartTime + (long)this.rotateTicks) {
                this.rotateStartTime = 0L;
                this.selected = (this.selected + 1) % 3;
                this.slots.forEach(s -> s.get().setTransform(s.transform()));
                this.sync(player);
            }
        } else if (time == this.rotateStartTime + (long)this.rotateTicks) {
            this.selected = (this.selected + 1) % 3;
        }
    }

    void sync(class_1657 player) {
        this.listener.markDirty(RootModuleHolder.Reason.SAVE_DATA);
    }

    @Override
    public void receivePacket(class_2540 buf) {
        this.rotateStartTime = buf.readLong();
        this.selected = buf.readInt();
    }

    public float getRotation(long time, float tickDelta) {
        float thing = (long)this.rotateTicks - (this.rotateStartTime + (long)this.rotateTicks - time);
        if (thing > (float)this.rotateTicks) {
            return 0.0f;
        }
        return class_3532.method_15363((float)((thing + tickDelta) / (float)this.rotateTicks), (float)0.0f, (float)1.0f);
    }

    public int getSelected() {
        return this.selected;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        super.writeNbt(nbt);
        nbt.method_10569("selected", this.selected);
        nbt.method_10544("rotate_start_time", this.rotateStartTime);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt, @Nullable Matrix4f global) {
        super.readNbt(nbt, global);
        this.selected = nbt.method_10550("selected");
        this.rotateStartTime = nbt.method_10537("rotate_start_time");
    }

    @Override
    public MeatgunModule.Type<? extends MeatgunModule> getType() {
        return MeatgunModules.TRIPLE_CAROUSEL;
    }

    private class TCSlot
    extends SimpleModuleSlot {
        private final int index;

        public TCSlot(RootModuleHolder.Listener listener, int index) {
            super(listener, new Matrix4f().rotateZ((float)index * 2.0f / 3.0f * (float)Math.PI).translate(0.0f, 0.25f, -0.125f));
            this.index = index;
        }

        @Override
        public Matrix4f transform() {
            return new Matrix4f().rotateZ((float)(this.index - TripleCarouselModule.this.selected) * 2.0f / 3.0f * (float)Math.PI).translate(0.0f, 0.25f, -0.125f);
        }

        @Override
        public Matrix4f transform(float tickDelta) {
            return super.transform(tickDelta);
        }
    }
}

