/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun.module;

import com.neep.meatweapons.MeatWeapons;
import com.neep.meatweapons.entity.ShockStaffProjectileEntity;
import com.neep.meatweapons.item.BaseGunItem;
import com.neep.meatweapons.meatgun.AmmunitionTransaction;
import com.neep.meatweapons.meatgun.AmmunitionType;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.AmmunitionRequiringModule;
import com.neep.meatweapons.meatgun.module.AmmunitionStoringModule;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import com.neep.meatweapons.meatgun.module.MeleeModule;
import com.neep.meatweapons.network.MWAttackC2SPacket;
import com.neep.meatweapons.network.MeatgunNetwork;
import com.neep.meatweapons.particle.MWParticles;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.util.NMMaths;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ShockStaffModule
extends MeleeModule
implements AmmunitionRequiringModule,
AmmunitionStoringModule {
    private int swingDownCooldown;
    private int ammoAmount;

    public ShockStaffModule(RootModuleHolder.Listener listener) {
        super(listener, List.of());
    }

    public ShockStaffModule(RootModuleHolder.Listener listener, class_2487 nbt) {
        this(listener);
    }

    @Override
    public MeatgunModule.Type<? extends MeatgunModule> getType() {
        return MeatgunModules.SHOCK_STAFF;
    }

    @Override
    public void trigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        if (id == 2 && this.swingDownCooldown == 0) {
            AmmunitionTransaction consume = this.consume(2, (class_1263)player.method_31548(), player);
            if (consume.notEmpty()) {
                MeatgunNetwork.SEND_ANIMATION.emitter(player).apply("swing_across", null);
                world.method_43129(null, (class_1297)player, NMSounds.SHOCK_STAFF_ATTACK, class_3419.field_15248, 1.0f, 1.0f);
                MeatgunNetwork.sendRecoil((class_3222)player, MeatgunNetwork.RecoilDirection.UP, 7.0f, 0.3f, 0.7f, 0.02f, hand);
                if (this.fireBeam(world, player, pitch, yaw, 3.0, hand)) {
                    consume.commit();
                }
                this.swingDownCooldown = 15;
            }
        } else if (id == 1 && this.swingDownCooldown == 0) {
            AmmunitionTransaction shootConsume = this.consume(1, (class_1263)player.method_31548(), player);
            if (shootConsume.notEmpty()) {
                shootConsume.commit();
                MeatgunNetwork.SEND_ANIMATION.emitter(player).apply("swing_across", null);
                world.method_43129(null, (class_1297)player, NMSounds.SHOCK_STAFF_ATTACK, class_3419.field_15248, 1.0f, 1.0f);
                ShockStaffProjectileEntity entity = (ShockStaffProjectileEntity)MeatWeapons.SHOCK_STAFF_PROJECTILE.method_5883(world);
                class_243 entityPos = player.method_33571();
                entity.method_7432((class_1297)player);
                entity.method_7438(this.baseDamage * 0.5f);
                entity.method_23327(entityPos.field_1352, entityPos.field_1351, entityPos.field_1350);
                entity.method_5814(entityPos.field_1352, entityPos.field_1351, entityPos.field_1350);
                if (this.listener.getHolder().containsType(MeatgunModules.HOMING_BRAIN)) {
                    entity.setHomingRadius(3.0f);
                }
                entity.method_24919((class_1297)player, (float)Math.toDegrees(pitch), (float)Math.toDegrees(yaw), 0.0f, 0.9f, 0.0f);
                entity.setHomingSpeed(0.45f, true);
                world.method_8649((class_1297)entity);
                this.swingDownCooldown = 15;
            } else {
                shootConsume.commit();
            }
        }
    }

    @Override
    public void release(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
    }

    @Override
    public void tickTrigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        super.tickTrigger(world, player, stack, id, pitch, yaw, handType, hand);
    }

    @Override
    public void tick(class_1657 player) {
        this.swingDownCooldown = Math.max(0, this.swingDownCooldown - 1);
    }

    @Override
    protected boolean fireBeam(class_1937 world, class_1657 player, double pitch, double yaw, double range, class_1268 hand) {
        class_243 pos = player.method_33571();
        class_243 end = pos.method_1019(NMMaths.getRotationVector(pitch, yaw).method_1021(range + 1.0));
        @Nullable class_3966 target = BaseGunItem.hitScan((class_1309)player, pos, end, range, e -> e != player.method_5854(), (world1, pos1, end1, width, maxTime, showRadius) -> {}, 0.4f).orElse(null);
        MeatgunNetwork.sendRecoil((class_3222)player, MeatgunNetwork.RecoilDirection.UP, 4.0f, 0.2f, 0.7f, 0.03f, hand);
        if (target != null && !target.method_17782().method_5626((class_1297)player) && target.method_17782().method_5732()) {
            class_1297 targetEntity = target.method_17782();
            if (!targetEntity.method_5698((class_1297)player)) {
                boolean crit = this.canCrit(player);
                targetEntity.method_5643(world.method_48963().method_48802(player), crit ? 1.5f * this.baseDamage : this.baseDamage);
                if (crit) {
                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15016, player.method_5634(), 1.0f, 1.0f);
                    player.method_7277(targetEntity);
                }
                class_243 targetPos = target.method_17784();
                world.method_43129(null, (class_1297)player, NMSounds.SHOCK_STAFF_HIT, class_3419.field_15248, 1.0f, 1.0f);
                ((class_3218)world).method_14199((class_2394)MWParticles.SHOCK_STAFF, targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 10, 0.05, 0.05, 0.05, 0.03);
            }
            return true;
        }
        return false;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        super.writeNbt(nbt);
        nbt.method_10569("ammo_amount", this.ammoAmount);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt, @Nullable Matrix4f global) {
        super.readNbt(nbt, global);
        this.ammoAmount = nbt.method_10550("ammo_amount");
    }

    @Override
    public int capacity() {
        return 16;
    }

    @Override
    public AmmunitionType ammoType() {
        return AmmunitionType.ENERGY;
    }

    @Override
    public int amount() {
        return this.ammoAmount;
    }

    @Override
    public int insert(int maxAmount) {
        int inserted = Math.min(maxAmount, this.capacity() - this.ammoAmount);
        if (inserted > 0) {
            this.ammoAmount += inserted;
        }
        return inserted;
    }

    @Override
    public int extract(int maxAmount) {
        int extracted = Math.min(this.ammoAmount, maxAmount);
        if (extracted > 0) {
            this.ammoAmount -= extracted;
            return extracted;
        }
        return 0;
    }

    public AmmunitionTransaction consume(int amount, class_1263 inventory, class_1657 player) {
        this.swingDownCooldown = 10;
        return this.listener.getHolder().getAmmoOrReload(this.ammoType(), amount, inventory, player);
    }
}

