/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun.module;

import com.neep.meatweapons.entity.BulletDamageSource;
import com.neep.meatweapons.meatgun.AmmunitionType;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.BosherModule;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import com.neep.meatweapons.meatgun.module.ShooterModule;
import com.neep.meatweapons.network.MWAttackC2SPacket;
import com.neep.meatweapons.particle.MWGraphicsEffects;
import com.neep.meatweapons.particle.MWParticles;
import com.neep.meatweapons.particle.MuzzleFlashParticleType;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.util.NMMaths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fc;
import org.joml.Vector4d;

public class BloodthrowerModule
extends ShooterModule {
    private final class_5819 shotRandom = class_5819.method_43047();

    public BloodthrowerModule(RootModuleHolder.Listener listener) {
        super(listener, AmmunitionType.BLOOD);
    }

    public BloodthrowerModule(RootModuleHolder.Listener listener, class_2487 nbt) {
        this(listener);
        this.readNbt(nbt, null);
    }

    @Override
    public MeatgunModule.Type<? extends MeatgunModule> getType() {
        return MeatgunModules.BLOODTHROWER;
    }

    @Override
    public void tick(class_1657 player) {
        this.cooldown = Math.max(0, this.cooldown - 1);
    }

    @Override
    public void trigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        if (this.cooldown == 0 && this.consume((class_1263)player.method_31548(), player)) {
            this.cooldown = this.maxCooldown;
            this.fireBeam(world, player, stack, pitch, yaw);
        }
    }

    @Override
    public void tickTrigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        this.trigger(world, player, stack, id, pitch, yaw, handType, hand);
    }

    protected void fireBeam(class_1937 world, class_1657 player, class_1799 stack, double pitchd, double yawd) {
        class_243 pos = player.method_33571();
        class_243 transform = this.getMuzzleOffset((class_1309)player, stack).method_1037((float)(-pitchd)).method_1024((float)(-yawd));
        pos = pos.method_1019(transform);
        List<class_1297> targets = BloodthrowerModule.hitScan((class_1309)player, pos, pitchd, yawd, 5, 40.0, 4.0, this.shotRandom);
        for (class_1297 target : targets) {
            if (!target.method_5805()) continue;
            target.method_5643((class_1282)BulletDamageSource.create(world, (class_1309)player, 0.0f), 0.5f);
            target.field_6008 = 0;
        }
        world.method_43129(null, (class_1297)player, NMSounds.BLOODTHROWER_ACTIVE, class_3419.field_15248, 1.0f, 1.0f);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            Vector4d v = new Vector4d(0.0, 0.0, -0.8125, 1.0);
            v.mul((Matrix4fc)this.transform.globalTransform);
            serverWorld.method_14199((class_2394)new MuzzleFlashParticleType.MuzzleFlashParticleEffect(MWParticles.BLOOD_MUZZLE_FLASH, player, v.x, v.y, v.z, 2.2f, 1), pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static List<class_1297> hitScan(@NotNull class_1309 caster, class_243 start, double pitch, double yaw, int numRays, double perturb, double distance, class_5819 random) {
        perturb = Math.toRadians(perturb);
        class_243 end = start.method_1019(NMMaths.getRotationVector(pitch, yaw).method_1021(distance));
        class_3959 ctx = new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)caster);
        class_3965 blockResult = caster.method_37908().method_17742(ctx);
        if (blockResult.method_17783() == class_239.class_240.field_1332) {
            end = blockResult.method_17784();
            distance = end.method_1022(start);
        }
        ArrayList<class_243> rays = new ArrayList<class_243>(numRays);
        for (int i = 0; i < numRays; ++i) {
            double yaw1 = yaw + perturb * ((double)random.method_43057() - 0.5);
            double pitch1 = pitch + perturb * ((double)random.method_43057() - 0.5);
            class_243 ray = NMMaths.getRotationVector(pitch1, yaw1).method_1021(distance);
            rays.add(ray);
            BloodthrowerModule.spawnParticle((class_3218)caster.method_37908(), start, ray.method_1029());
        }
        Predicate<class_1297> entityFilter = entity -> !entity.method_7325() && entity.method_5863();
        ArrayList<class_1297> targets = new ArrayList<class_1297>();
        for (class_239 hit : BosherModule.getRayTargets(caster, start, end, rays, distance, entityFilter, 0.1)) {
            if (hit.method_17783() != class_239.class_240.field_1331) continue;
            targets.add(((class_3966)hit).method_17782());
        }
        return targets;
    }

    private static void spawnParticle(class_3218 world, class_243 start, class_243 ray) {
        world.method_14199((class_2394)MWParticles.BLOODTHROWER_SPLASH, start.field_1352, start.field_1351, start.field_1350, 0, ray.field_1352, ray.field_1351, ray.field_1350, 0.8);
    }

    private static void syncBeamEffect(class_3218 world, class_243 pos, class_243 end, float width, int maxTime, double showRadius) {
        class_243 col = new class_243(214.0, 175.0, 32.0);
        for (class_3222 player : PlayerLookup.around((class_3218)world, (class_243)pos, (double)showRadius)) {
            MWGraphicsEffects.syncBeamEffect(player, MWGraphicsEffects.BULLET_TRAIL, (class_1937)world, pos, end, col, 0.1f, 1);
        }
    }
}

