/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun.module;

import com.neep.meatweapons.meatgun.AmmunitionTransaction;
import com.neep.meatweapons.meatgun.AmmunitionType;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.AbstractMeatgunModule;
import com.neep.meatweapons.meatgun.module.AmmunitionRequiringModule;
import com.neep.meatweapons.meatgun.module.AmmunitionStoringModule;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class AmmunitionUsingModule
extends AbstractMeatgunModule
implements AmmunitionRequiringModule,
AmmunitionStoringModule {
    protected int ammoAmount;
    private final AmmunitionType type;

    protected AmmunitionUsingModule(RootModuleHolder.Listener listener, AmmunitionType type) {
        super(listener);
        this.type = type;
        this.ammoAmount = 0;
    }

    @Override
    public int capacity() {
        return this.getType().capacity();
    }

    @Override
    public int amount() {
        return this.ammoAmount;
    }

    @Override
    public int insert(int maxAmount) {
        int inserted = Math.min(maxAmount, this.capacity() - this.ammoAmount);
        if (inserted > 0) {
            this.ammoAmount += inserted;
        }
        return inserted;
    }

    @Override
    public int extract(int maxAmount) {
        int extracted = Math.min(this.ammoAmount, maxAmount);
        if (extracted > 0) {
            this.ammoAmount -= extracted;
            return extracted;
        }
        return 0;
    }

    protected boolean consume(int amount, class_1263 inventory, class_1657 player) {
        AmmunitionTransaction consume = this.listener.getHolder().getAmmoOrReload(this.ammoType(), amount, inventory, player);
        if (consume.notEmpty()) {
            consume.commit();
            return true;
        }
        return false;
    }

    protected abstract boolean consume(class_1263 var1, class_1657 var2);

    @Override
    public AmmunitionType ammoType() {
        return this.type;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        super.writeNbt(nbt);
        nbt.method_10569("stored", this.ammoAmount);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt, @Nullable Matrix4f global) {
        super.readNbt(nbt, global);
        this.ammoAmount = nbt.method_10550("stored");
    }
}

