/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.neep.meatweapons.meatgun.AmmunitionType;
import com.neep.meatweapons.meatgun.module.AmmunitionStoringModule;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.ModuleSlot;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ModuleCache {
    private final MeatgunModule root;
    @Nullable
    private Map<UUID, MeatgunModule> uuidLookup = null;
    @Nullable
    private Map<AmmunitionType, List<AmmunitionStoringModule>> ammunition;
    @Nullable
    private Set<MeatgunModule.Type<?>> moduleTypes;
    @Nullable
    private Multimap<MeatgunModule.Type<?>, MeatgunModule> typeToModules;

    public ModuleCache(MeatgunModule root) {
        this.root = root;
    }

    @Nullable
    public MeatgunModule findModule(UUID uuid) {
        if (this.uuidLookup == null) {
            this.uuidLookup = this.makeModuleCache();
        }
        return this.uuidLookup.get(uuid);
    }

    @Nullable
    public MeatgunModule findModule(MeatgunModule.Type<?> type) {
        if (this.uuidLookup == null) {
            this.uuidLookup = this.makeModuleCache();
        }
        for (MeatgunModule module : this.uuidLookup.values()) {
            if (module.getType() != type) continue;
            return module;
        }
        return null;
    }

    public int getAmmo(AmmunitionType type) {
        if (this.ammunition == null) {
            this.ammunition = this.makeAmmoCache();
        }
        return this.ammunition.getOrDefault((Object)type, List.of()).stream().mapToInt(AmmunitionStoringModule::amount).sum();
    }

    public int getCapacity(AmmunitionType type) {
        if (this.ammunition == null) {
            this.ammunition = this.makeAmmoCache();
        }
        return this.ammunition.getOrDefault((Object)type, List.of()).stream().mapToInt(AmmunitionStoringModule::capacity).sum();
    }

    public Map<AmmunitionType, List<AmmunitionStoringModule>> getAmmo() {
        if (this.ammunition == null) {
            this.ammunition = this.makeAmmoCache();
        }
        return this.ammunition;
    }

    public Collection<MeatgunModule> getModules() {
        if (this.uuidLookup == null) {
            this.uuidLookup = this.makeModuleCache();
        }
        return this.uuidLookup.values();
    }

    public Set<MeatgunModule.Type<?>> moduleTypes() {
        if (this.moduleTypes == null) {
            this.moduleTypes = this.makeTypeCache();
        }
        return this.moduleTypes;
    }

    public Collection<MeatgunModule> modulesOfType(MeatgunModule.Type<?> type) {
        if (this.typeToModules == null) {
            this.typeToModules = this.makeTypeToModuleCache();
        }
        return this.typeToModules.get(type);
    }

    private Multimap<MeatgunModule.Type<?>, MeatgunModule> makeTypeToModuleCache() {
        SetMultimap map = MultimapBuilder.hashKeys().hashSetValues().build();
        if (this.uuidLookup == null) {
            this.uuidLookup = this.makeModuleCache();
        }
        this.uuidLookup.values().forEach(arg_0 -> ModuleCache.lambda$makeTypeToModuleCache$0((Multimap)map, arg_0));
        return map;
    }

    private Map<UUID, MeatgunModule> makeModuleCache() {
        HashMap<UUID, MeatgunModule> map = new HashMap<UUID, MeatgunModule>();
        this.addRecursive(this.root, map);
        this.ammunition = null;
        this.moduleTypes = null;
        this.typeToModules = null;
        return map;
    }

    private Map<AmmunitionType, List<AmmunitionStoringModule>> makeAmmoCache() {
        if (this.uuidLookup == null) {
            this.uuidLookup = this.makeModuleCache();
        }
        EnumMap<AmmunitionType, List<AmmunitionStoringModule>> map = new EnumMap(AmmunitionType.class);
        map = this.uuidLookup.values().stream().filter(m -> {
            AmmunitionStoringModule module;
            return m instanceof AmmunitionStoringModule && (module = (AmmunitionStoringModule)((Object)m)).ammoType() != null;
        }).map(m -> (AmmunitionStoringModule)((Object)m)).collect(Collectors.groupingBy(AmmunitionStoringModule::ammoType, () -> new EnumMap(AmmunitionType.class), Collectors.toList()));
        return map;
    }

    private Set<MeatgunModule.Type<?>> makeTypeCache() {
        if (this.uuidLookup == null) {
            this.uuidLookup = this.makeModuleCache();
        }
        HashSet types = new HashSet();
        for (MeatgunModule module : this.uuidLookup.values()) {
            types.add(module.getType());
        }
        return types;
    }

    private void addRecursive(MeatgunModule module, Map<UUID, MeatgunModule> collector) {
        collector.put(module.getUuid(), module);
        for (ModuleSlot slot : module.getChildren()) {
            MeatgunModule child = slot.get();
            if (child == MeatgunModule.DEFAULT) continue;
            this.addRecursive(child, collector);
        }
    }

    @Nullable
    private MeatgunModule findRecursive(MeatgunModule module, UUID uuid) {
        if (module.getUuid().equals(uuid)) {
            return module;
        }
        for (ModuleSlot slot : module.getChildren()) {
            MeatgunModule child = slot.get();
            if (child == MeatgunModule.DEFAULT) continue;
            if (child.getUuid().equals(uuid)) {
                return child;
            }
            MeatgunModule next = this.findRecursive(child, uuid);
            if (next == null) continue;
            return next;
        }
        return null;
    }

    public void invalidate() {
        this.uuidLookup = null;
        this.ammunition = null;
        this.moduleTypes = null;
    }

    private static /* synthetic */ void lambda$makeTypeToModuleCache$0(Multimap map, MeatgunModule m) {
        map.put(m.getType(), (Object)m);
    }
}

