/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun;

import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.meatweapons.meatgun.AmmunitionType;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.neepmeat.component.PowerResourceComponent;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.item.util.LivingTools;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import org.jetbrains.annotations.Nullable;

public record MeatgunCore(RootModuleHolder holder) {
    public long acceptResource(FluidVariant variant, long maxAmount, TransactionContext transaction) {
        int fluidPerDurability = LivingTools.getFluidForDurability(variant);
        if (fluidPerDurability != -1) {
            float perDroplet = 1.0f / (float)fluidPerDurability;
            int equivalentAmmo = (int)Math.floor((float)maxAmount * perDroplet);
            AmmunitionType type = AmmunitionType.METABOLIC;
            int previous = this.holder.moduleCache().getAmmo(type);
            int capacity = this.holder.moduleCache().getCapacity(type);
            int toInsert = Math.min(equivalentAmmo, capacity - previous);
            transaction.addCloseCallback((t, r) -> MeatlibStorageUtil.closeCallback(t, r, () -> {
                this.holder.insertAmmo(AmmunitionType.METABOLIC, toInsert);
                this.holder.markDirty(RootModuleHolder.Reason.SAVE_DATA);
            }));
            long toReturn = (long)((float)toInsert / perDroplet);
            if ((float)(maxAmount - toReturn) < 1.0f / perDroplet) {
                return maxAmount;
            }
            return toReturn;
        }
        return 0L;
    }

    public boolean canRun(class_1657 playerEntity, int min) {
        AmmunitionType fuelType = this.getResource();
        if (fuelType == AmmunitionType.AIR) {
            PowerResourceComponent component = (PowerResourceComponent)NMComponents.COMPRESSED_AIR.getNullable((Object)playerEntity);
            return component != null && component.getAir() > 0L;
        }
        if (fuelType == AmmunitionType.METABOLIC) {
            int amount = this.holder.moduleCache().getAmmo(AmmunitionType.METABOLIC);
            return amount > min;
        }
        return false;
    }

    public int getAmount() {
        return this.holder.moduleCache().getAmmo(AmmunitionType.METABOLIC);
    }

    public int getCapacity() {
        return this.holder.moduleCache().getCapacity(AmmunitionType.METABOLIC);
    }

    @Nullable
    public AmmunitionType getResource() {
        return this.holder.coreImplants().fuelType();
    }
}

