/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.item.meatgun;

import com.neep.meatweapons.client.meatgun.animation.MeatgunAnimation;
import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.item.meatgun.Meatgun;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MeatgunAnimationManager {
    private static final Map<UUID, MeatgunAnimationManager> INSTANCES = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.SOFT, true);
    private final MeatgunAnimation idle;
    private MeatgunAnimation activeAnimation = MeatgunAnimation.EMPTY;
    private final Map<String, MeatgunAnimation> animations = new HashMap<String, MeatgunAnimation>();

    public static MeatgunAnimationManager getOrCreate(UUID uuid, Meatgun meatgun) {
        return INSTANCES.computeIfAbsent(uuid, u -> (MeatgunAnimationManager)meatgun.createAnimationManager().get());
    }

    public MeatgunAnimationManager(MeatgunAnimation idle) {
        this.idle = idle;
        this.activeAnimation = idle;
        this.activeAnimation.start(null);
    }

    public void queue(String name, @Nullable class_2540 buf) {
        @Nullable MeatgunAnimation animation = this.animations.get(name);
        if (animation != null) {
            this.queue(animation, buf);
        }
    }

    public void queue(MeatgunAnimation animation, @Nullable class_2540 buf) {
        if (this.activeAnimation.canStop(animation)) {
            this.activeAnimation = animation;
            this.activeAnimation.start(buf);
        }
    }

    public void tick(MeatgunComponent component) {
        if (this.activeAnimation.finished()) {
            this.activeAnimation = this.idle;
            this.activeAnimation.start(null);
        }
        this.activeAnimation.tick(component);
    }

    public MeatgunAnimation getActive() {
        return this.activeAnimation;
    }

    public MeatgunAnimationManager add(String name, MeatgunAnimation animation) {
        this.animations.put(name, animation);
        return this;
    }
}

