/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.component;

import com.neep.meatlib.MeatLib;
import com.neep.meatweapons.client.meatgun.RecoilManager;
import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.item.meatgun.Meatgun;
import com.neep.meatweapons.item.meatgun.MeatgunAnimationManager;
import com.neep.meatweapons.meatgun.MeatgunCore;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.network.MWAttackC2SPacket;
import com.neep.neepmeat.implant.entity.ImplantManager;
import com.neep.neepmeat.implant.item.ItemImplantManager;
import com.neep.neepmeat.init.NMComponents;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class MeatgunComponentImpl
extends ItemComponent
implements MeatgunComponent {
    @Nullable
    private RecoilManager recoil;
    private RootModuleHolder holder = this.initUUID();
    private boolean dirty = true;
    private boolean invalidated = false;
    @Environment(value=EnvType.CLIENT)
    private MeatgunAnimationManager animationManager;

    public MeatgunComponentImpl(class_1799 stack, ComponentKey<MeatgunComponent> key) {
        super(stack, key);
        this.holder.setComponent(this);
        if (MeatLib.isClient() || this.holder.isNew()) {
            this.holder.readNbt(this.getOrCreateRootTag().method_10562("root"));
        }
    }

    @Override
    public RootModuleHolder getRootHolder() {
        return this.holder;
    }

    @Override
    public RootModuleHolder initUUID() {
        Meatgun meatgun = (Meatgun)this.getStack().method_7909();
        boolean isServer = !MeatLib.isClient();
        UUID foundUUID = this.getUuid("meatgun_uuid");
        if (foundUUID == null || foundUUID.equals(RootModuleHolder.NULL_UUID)) {
            foundUUID = RootModuleHolder.NULL_UUID;
            this.putUuid("meatgun_uuid", foundUUID);
            return new RootModuleHolder(meatgun);
        }
        return meatgun.getCache().getOrCreate(foundUUID, meatgun, isServer);
    }

    @Override
    public void trigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        this.holder.root.trigger(world, player, stack, id, pitch, yaw, handType, hand);
    }

    @Override
    public void release(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        this.holder.root.release(world, player, stack, id, pitch, yaw, handType, hand);
    }

    @Override
    public void tickTrigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        this.holder.root.tickTrigger(world, player, stack, id, pitch, yaw, handType, hand);
    }

    @Override
    public RecoilManager getRecoil() {
        if (this.recoil == null) {
            this.recoil = RecoilManager.getOrCreate(this.getUuid());
        }
        return this.recoil;
    }

    @Override
    @Nullable
    public MeatgunAnimationManager getAnimationManager() {
        return this.animationManager;
    }

    @Override
    public class_1799 getStack() {
        return this.stack;
    }

    @Override
    public void commonTick(class_1657 player) {
        if (this.getUuid().equals(RootModuleHolder.NULL_UUID)) {
            UUID newUUID = UUID.randomUUID();
            this.putUuid("meatgun_uuid", newUUID);
            Meatgun meatgun = (Meatgun)this.stack.method_7909();
            this.holder = meatgun.getCache().getOrCreate(newUUID, meatgun, !player.method_37908().method_8608());
            this.holder.setComponent(this);
            class_1799 defaultStack = this.stack.method_7909().method_7854();
            meatgun.createDefaultTree(this.holder.root, this.holder.getListener());
            ItemImplantManager defaultImplants = (ItemImplantManager)NMComponents.IMPLANT_MANAGER.get((Object)defaultStack);
            defaultImplants.copyTo((ImplantManager)NMComponents.IMPLANT_MANAGER.get((Object)this.stack));
        }
        this.holder.root.tick(player);
        if (!player.method_37908().method_8608()) {
            if (this.dirty) {
                this.getOrCreateRootTag().method_10566("root", (class_2520)this.holder.root.writeNbt(new class_2487()));
                this.dirty = false;
            }
            if (this.invalidated) {
                if (!this.getOrCreateRootTag().method_10545("root")) {
                    this.holder.root.readNbt(this.getOrCreateRootTag(), new Matrix4f());
                } else {
                    this.holder.root.readNbt(this.getOrCreateRootTag().method_10562("root"), new Matrix4f());
                }
                this.invalidated = false;
            }
        }
    }

    @Override
    public void clientTick(class_1657 player) {
        if (this.animationManager == null) {
            this.animationManager = MeatgunAnimationManager.getOrCreate(this.getUuid(), (Meatgun)this.stack.method_7909());
        }
        this.animationManager.tick(this);
    }

    @Override
    public void markDirty() {
        this.getOrCreateRootTag().method_10566("root", (class_2520)this.holder.root.writeNbt(new class_2487()));
    }

    public void onTagInvalidated() {
        super.onTagInvalidated();
        this.dirty = true;
        this.invalidated = true;
    }

    @Override
    public UUID getUuid() {
        return this.getUuid("meatgun_uuid");
    }

    @Override
    public MeatgunCore getCore() {
        return new MeatgunCore(this.getRootHolder());
    }
}

