/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.client.screen.meatgun;

import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.TooltipHelper;
import com.neep.meatlib.client.screen.primitive.MutableRectangle;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatweapons.client.screen.meatgun.TinkerTableScreen;
import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.init.MWComponents;
import com.neep.meatweapons.item.meatgun.MeatgunModuleItem;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import com.neep.meatweapons.meatgun.module.ModuleSlot;
import com.neep.meatweapons.meatgun.module.SimpleModuleSlot;
import com.neep.meatweapons.screen.TinkerTableScreenHandler;
import com.neep.neepmeat.api.plc.PLCCols;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

class TreePane
extends TinkerTableScreen.PaneWidget {
    private final class_327 textRenderer;
    private final List<ModuleWidget> moduleWidgets;
    private final TinkerTableScreenHandler handler;
    private final class_1735 slot;
    @Nullable
    private MeatgunComponent meatgun;
    private boolean scissor;
    private float ox;
    private float oy;

    public TreePane(TinkerTableScreenHandler handler, class_1735 itemSlot) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.moduleWidgets = new ArrayList<ModuleWidget>();
        this.handler = handler;
        this.slot = itemSlot;
    }

    @Override
    public void init() {
        super.init();
        this.ox = (float)this.x() + (float)this.w() / 2.0f;
        this.oy = this.y() + 10;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.enableScissor(context);
        for (ModuleWidget moduleWidget : this.moduleWidgets) {
            moduleWidget.method_25394(context, mouseX, mouseY, delta);
        }
        this.disableScissor(context);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        double thing = 1.0;
        this.ox += (float)(deltaX * thing);
        this.oy += (float)(deltaY * thing);
        this.updateWidgetOrigins();
        return true;
    }

    private void updateWidgetOrigins() {
        for (ModuleWidget widget : this.moduleWidgets) {
            widget.updateOrigin(Math.round(this.ox), Math.round(this.oy));
        }
    }

    private void reorganise() {
        this.moduleWidgets.clear();
        if (this.meatgun == null) {
            return;
        }
        ArrayList<List<ModuleWidget>> levels = new ArrayList<List<ModuleWidget>>();
        MeatgunModule root = this.meatgun.getRootHolder().root;
        this.process(levels, 0, root);
        int thingHeight = ModuleWidget.height() + 5;
        int offsetY = 0;
        for (List list : levels) {
            int totalWidth = 0;
            int padding = 4;
            for (ModuleWidget widget : list) {
                totalWidth += widget.width() + padding;
            }
            int offsetX = -totalWidth / 2;
            for (ModuleWidget widget : list) {
                widget.init(offsetX, offsetY);
                offsetX += widget.width() + padding;
                this.moduleWidgets.add(widget);
            }
            offsetY += thingHeight;
        }
        this.updateWidgetOrigins();
    }

    private void process(List<List<ModuleWidget>> levels, int level, MeatgunModule module) {
        if (levels.size() == level) {
            levels.add(new ArrayList());
        }
        ModuleWidget widget = new ModuleWidget(this.textRenderer, module);
        levels.get(level).add(widget);
        for (ModuleSlot slot : module.getChildren()) {
            if (slot.get() == MeatgunModule.DEFAULT) continue;
            this.process(levels, level + 1, slot.get());
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isWithin(mouseX, mouseY)) {
            for (ModuleWidget widget : this.moduleWidgets) {
                if (!widget.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    private void enableScissor(class_332 context) {
        context.method_44379(this.x() + 2, this.y() + 2, this.x() + this.w() - 2, this.y() + this.h() - 2);
        this.scissor = true;
    }

    private void disableScissor(class_332 context) {
        context.method_44380();
        this.scissor = false;
    }

    public void tick() {
        this.meatgun = (MeatgunComponent)MWComponents.MEATGUN.getNullable((Object)this.slot.method_7677());
        this.reorganise();
    }

    private class ModuleWidget
    implements class_4068 {
        private final MeatgunModule module;
        private int ox;
        private int oy;
        private int absX;
        private int absY;
        private final MutableRectangle bounds = new MutableRectangle(0, 0, 0, 0);
        private final class_327 textRenderer;
        private final List<ModuleSlotWidget> slots = new ArrayList<ModuleSlotWidget>();

        public ModuleWidget(class_327 textRenderer, MeatgunModule module) {
            this.textRenderer = textRenderer;
            this.module = module;
            for (int slotIdx = 0; slotIdx < module.getChildren().size(); ++slotIdx) {
                ModuleSlot slot = module.getChildren().get(slotIdx);
                ModuleSlotWidget slotWidget = new ModuleSlotWidget(textRenderer, module, slotIdx, slot);
                this.slots.add(slotWidget);
            }
        }

        public void init(int x, int y) {
            this.absX = x;
            this.absY = y;
            this.updateBounds();
            if (this.slots.size() > 0) {
                float spacing = (float)this.bounds.w() / (float)this.slots.size();
                int offsetX = (int)((float)this.width() - ((float)(18 * this.slots.size()) + (float)(this.slots.size() - 1) * (spacing - 18.0f))) / 2;
                for (ModuleSlotWidget slot : this.slots) {
                    slot.init(this.bounds.x() + offsetX, this.bounds.y() + this.bounds.h() - ModuleSlotWidget.height() - 2);
                    offsetX = (int)((float)offsetX + spacing);
                }
            }
        }

        public void updateOrigin(int ox, int oy) {
            this.ox = ox;
            this.oy = oy;
            for (ModuleSlotWidget slot : this.slots) {
                slot.updateOrigin(ox, oy);
            }
            this.updateBounds();
        }

        private void updateBounds() {
            this.bounds.set(this.ox + this.absX, this.oy + this.absY, this.width(), ModuleWidget.height());
        }

        public int width() {
            return this.textRenderer.method_27525((class_5348)this.getName()) + 4;
        }

        public static int height() {
            return ModuleSlotWidget.height() + 9 + 5;
        }

        public class_2561 getName() {
            class_2960 id = MeatgunModules.REGISTRY.method_10221(this.module.getType());
            return class_2561.method_43471((String)id.method_42093("meatgun_module"));
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            GUIUtil.drawText(context, this.textRenderer, this.getName(), (float)(this.bounds.x() + 3), (float)(this.bounds.y() + 2), PLCCols.TEXT.col, false);
            GUIUtil.renderBorder(context, this.bounds.x(), this.bounds.y(), this.bounds.w(), this.bounds.h(), PLCCols.BORDER.col, 0);
            for (ModuleSlotWidget slot : this.slots) {
                slot.method_25394(context, mouseX, mouseY, delta);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.bounds.isWithin(mouseX, mouseY)) {
                for (ModuleSlotWidget slot : this.slots) {
                    if (!slot.mouseClicked(mouseX, mouseY, button)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class ModuleSlotWidget
    implements class_4068 {
        private static final Rectangle size = new Rectangle.Immutable(0, 0, 18, 18);
        private final class_327 textRenderer;
        private final MeatgunModule module;
        private final int slotIdx;
        private final ModuleSlot slot1;
        private Rectangle local = new Rectangle.Immutable(size);
        private Rectangle bounds = new Rectangle.Immutable(size);
        private final class_1799 defaultStack;

        public ModuleSlotWidget(class_327 textRenderer, MeatgunModule module, int slotIdx, ModuleSlot slot) {
            this.textRenderer = textRenderer;
            this.module = module;
            this.slotIdx = slotIdx;
            this.slot1 = slot;
            MeatgunModule module1 = this.slot1.get();
            this.defaultStack = module1.getType() != MeatgunModule.DEFAULT_TYPE ? MeatgunModuleItem.get(module1) : class_1799.field_8037;
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            int bordereCol = PLCCols.BORDER.col;
            if (this.bounds.isWithin(mouseX, mouseY)) {
                bordereCol = PLCCols.SELECTED.col;
                this.renderTooltip(context, mouseX, mouseY, delta);
            }
            GUIUtil.drawTexture(TinkerTableScreen.WIDGETS_TEXTURE, context, this.bounds.x(), this.bounds.y(), 0, 0, 18, 19, bordereCol);
            context.method_51427(this.defaultStack, this.bounds.x() + 1, this.bounds.y() + 1);
        }

        private void renderTooltip(class_332 context, int mouseX, int mouseY, float delta) {
            if (TreePane.this.scissor) {
                TreePane.this.disableScissor(context);
                if (this.defaultStack.method_7960()) {
                    ModuleSlot moduleSlot = this.slot1;
                    if (moduleSlot instanceof SimpleModuleSlot) {
                        SimpleModuleSlot simpleSlot = (SimpleModuleSlot)moduleSlot;
                        RenderSystem.enableDepthTest();
                        TooltipHelper.get().draw(context, mouseX, mouseY, List.of(class_2561.method_30163((String)simpleSlot.getSlotType().toString())));
                        RenderSystem.disableDepthTest();
                    }
                } else {
                    context.method_51446(this.textRenderer, this.defaultStack, mouseX, mouseY);
                }
                context.method_51452();
                TreePane.this.enableScissor(context);
            } else {
                context.method_51446(this.textRenderer, this.defaultStack, mouseX, mouseY);
            }
        }

        public void updateOrigin(int ox, int oy) {
            this.bounds = this.local.offset(ox, oy);
        }

        public static int width() {
            return size.w();
        }

        public static int height() {
            return size.h();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.bounds.isWithin(mouseX, mouseY)) {
                TreePane.this.handler.slotClick.emitter().apply(this.module.getUuid(), this.slotIdx);
                return true;
            }
            return false;
        }

        public void init(int x, int y) {
            this.local = size.offset(x, y);
        }
    }
}

