/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.transfer;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class MultiFluidBuffer
extends SnapshotParticipant<Map<FluidVariant, Long>>
implements Storage<FluidVariant> {
    long capacity;
    protected final Runnable finalCallback;
    Predicate<FluidVariant> validTypes;
    protected final Object2LongOpenHashMap<FluidVariant> map = new Object2LongOpenHashMap();

    public MultiFluidBuffer(long capacity, Predicate<FluidVariant> validTypes, Runnable finalCallback) {
        this.capacity = capacity;
        this.validTypes = validTypes;
        this.finalCallback = finalCallback;
    }

    public String toString() {
        return this.map.toString();
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long insertedAmount = Math.min(maxAmount, this.getSpace());
        if (insertedAmount > 0L) {
            this.updateSnapshots(transaction);
            this.map.compute((Object)resource, (r, a) -> a != null ? a + insertedAmount : insertedAmount);
        }
        return insertedAmount;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long amount = this.map.getLong((Object)resource);
        long extracted = Math.min(maxAmount, amount);
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.map.addTo((Object)resource, -extracted);
            if (amount - extracted <= 0L) {
                this.map.remove((Object)resource);
            }
        }
        return extracted;
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return this.map.object2LongEntrySet().stream().map(this::ofEntry).iterator();
    }

    protected StorageView<FluidVariant> ofEntry(Map.Entry<FluidVariant, Long> entry) {
        SingleVariantStorage<FluidVariant> view = new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return MultiFluidBuffer.this.getCapacity();
            }

            public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
                return MultiFluidBuffer.this.insert(insertedVariant, maxAmount, transaction);
            }

            public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
                return MultiFluidBuffer.this.extract(extractedVariant, maxAmount, transaction);
            }
        };
        view.variant = (TransferVariant)entry.getKey();
        view.amount = entry.getValue();
        return view;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        this.map.forEach((r, a) -> {
            class_2487 comp = r.toNbt();
            comp.method_10544("amount", a.longValue());
            list.add((Object)comp);
        });
        nbt.method_10566("parts", (class_2520)list);
        return nbt;
    }

    public void readNbt(class_2487 nbt) {
        class_2499 list = nbt.method_10554("parts", 10);
        if (list == null) {
            return;
        }
        this.map.clear();
        list.forEach(c -> this.map.put((Object)FluidVariant.fromNbt((class_2487)((class_2487)c)), ((class_2487)c).method_10537("amount")));
    }

    public boolean handleInteract(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand));
        if (storage != null) {
            if (player.method_7337()) {
                try (Transaction transaction = Transaction.openOuter();){
                    StorageView view = (StorageView)storage.iterator().next();
                    if (!view.isResourceBlank()) {
                        class_3414 fill = class_3417.field_15126;
                        world.method_8396(null, player.method_24515(), fill, class_3419.field_15245, 1.0f, 1.5f);
                        this.insert((FluidVariant)view.getResource(), view.getAmount(), (TransactionContext)transaction);
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                    transaction.abort();
                }
            }
            if (StorageUtil.move((Storage)storage, (Storage)this, variant -> true, (long)Long.MAX_VALUE, null) > 0L) {
                return true;
            }
            if (StorageUtil.move((Storage)this, (Storage)storage, variant -> true, (long)Long.MAX_VALUE, null) > 0L) {
                return true;
            }
        }
        return false;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getTotalAmount() {
        AtomicLong l = new AtomicLong();
        Object2LongMaps.fastForEach(this.map, entry -> l.addAndGet(entry.getLongValue()));
        return l.get();
    }

    public long getSpace() {
        return this.getCapacity() - this.getTotalAmount();
    }

    public Object2LongMap.FastEntrySet<FluidVariant> getSlots() {
        return this.map.object2LongEntrySet();
    }

    protected Map<FluidVariant, Long> createSnapshot() {
        return this.map.clone();
    }

    protected void readSnapshot(Map<FluidVariant, Long> snapshot) {
        this.map.clear();
        this.map.putAll(snapshot);
    }

    protected void onFinalCommit() {
        super.onFinalCommit();
        this.finalCallback.run();
    }
}

