/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.recipe.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.meatlib.recipe.ingredient.IngredientType;
import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.NbtMatcher;
import com.neep.meatlib.recipe.ingredient.RecipeInput;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class RegistryRecipeInputSerialiser<R>
implements RecipeInput.Serialiser<R, StorageView<? extends TransferVariant<?>>, RegistryRecipeInput<R>> {
    public static final RegistryRecipeInputSerialiser<Object> EMPTY = (RegistryRecipeInputSerialiser)class_2378.method_10230(RecipeInputs.SERIALISERS, (class_2960)Ingredients.EMPTY_ID, (Object)new RegistryRecipeInputSerialiser<Object>((class_2378)class_7923.field_41178, null){

        @Override
        public RegistryRecipeInput<Object> fromBuffer(class_2540 buf) {
            return RecipeInputs.EMPTY;
        }

        @Override
        public IngredientType<Object> getType() {
            return Ingredients.EMPTY;
        }

        @Override
        public Codec<RegistryRecipeInput<Object>> codec() {
            return Codec.unit(RecipeInputs.EMPTY);
        }
    });
    private final class_2378<R> registry;
    private final IngredientType<R> type;
    private final Codec<RegistryRecipeInput<R>> codec;
    private final ParamCodec<RegistryRecipeInput<R>> paramCodec;

    public RegistryRecipeInputSerialiser(class_2378<R> registry, IngredientType<R> type) {
        this.registry = registry;
        this.type = type;
        this.codec = RegistryRecipeInputSerialiser.makeCodec(registry, this, type);
        this.paramCodec = ParamCodec.of(ParamCodecs.as(RegistryRecipeInput.class), RegistryRecipeInput::write, RegistryRecipeInput::fromBuffer);
    }

    public static <R> Codec<RegistryRecipeInput<R>> makeCodec(class_2378<R> registry, RegistryRecipeInputSerialiser<R> serialiser, IngredientType<R> type) {
        MapCodec amountCodec = Codec.LONG.fieldOf("amount");
        MapCodec matcherCodec = NbtMatcher.CODEC.optionalFieldOf("data", (Object)NbtMatcher.ANY);
        Codec codec1 = RecordCodecBuilder.create(instance -> instance.group((App)registry.method_39673().xmap(RegistryRecipeInput.ResourceEntry::new, RegistryRecipeInput.ResourceEntry::getObject).fieldOf("resource").forGetter(i -> null), (App)amountCodec.forGetter(RegistryRecipeInput::amount), (App)matcherCodec.forGetter(RegistryRecipeInput::nbtMatcher)).apply((Applicative)instance, (c, a, n) -> new RegistryRecipeInput(c, (long)a, serialiser, type, (NbtMatcher)n)));
        Codec codec2 = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInput.tagKeyCodec(registry).xmap(RegistryRecipeInput.TagEntry::new, RegistryRecipeInput.TagEntry::getTag).fieldOf("tag").forGetter(i -> null), (App)amountCodec.forGetter(RegistryRecipeInput::amount), (App)matcherCodec.forGetter(RegistryRecipeInput::nbtMatcher)).apply((Applicative)instance, (c, a, n) -> new RegistryRecipeInput(c, (long)a, serialiser, type, (NbtMatcher)n)));
        return Codec.either((Codec)codec1, (Codec)codec2).xmap(e -> {
            if (e.left().isPresent()) {
                return (RegistryRecipeInput)e.left().get();
            }
            return (RegistryRecipeInput)e.right().orElseThrow();
        }, Either::left);
    }

    @Override
    public RegistryRecipeInput<R> fromBuffer(class_2540 buf) {
        RegistryRecipeInput.Entry<Object> entry = null;
        boolean isTag = buf.readBoolean();
        if (isTag) {
            id = buf.method_10810();
            class_6862 tagKey = class_6862.method_40092((class_5321)this.registry.method_30517(), (class_2960)id);
            entry = new RegistryRecipeInput.TagEntry(tagKey);
        } else {
            id = buf.method_10810();
            Object r = this.registry.method_10223(id);
            entry = new RegistryRecipeInput.ResourceEntry<Object>(r);
        }
        long amount = buf.method_10792();
        NbtMatcher matcher = NbtMatcher.read(buf);
        return new RegistryRecipeInput<Object>(entry, amount, this, this.type, matcher);
    }

    @Override
    public void write(class_2540 buf, RegistryRecipeInput<R> input) {
        RecipeInput.Serialiser.super.write(buf, input);
        boolean isTag = input.entry instanceof RegistryRecipeInput.TagEntry;
        buf.writeBoolean(isTag);
        if (isTag) {
            buf.method_10812(((RegistryRecipeInput.TagEntry)input.entry).tag.comp_327());
        } else {
            buf.method_10812(this.type.getIdFor(((RegistryRecipeInput.ResourceEntry)input.entry).getObject()));
        }
        buf.method_10791(input.amount());
        input.nbtMatcher.write(buf);
    }

    @Override
    public IngredientType<R> getType() {
        return this.type;
    }

    @Override
    public Codec<RegistryRecipeInput<R>> codec() {
        return this.codec;
    }

    public ParamCodec<RegistryRecipeInput<R>> paramCodec() {
        return this.paramCodec;
    }
}

