/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.recipe.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.MeatLib;
import com.neep.meatlib.recipe.ingredient.IngredientType;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.util.MeatLibCodecs;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class RecipeOutputImpl<T>
implements RecipeOutput<T> {
    private final T resource;
    private final class_6019 lootFunction;
    private final class_5819 random;
    private final float chance;
    private final IngredientType<T> type;
    @Nullable
    private final class_2487 nbt;

    public RecipeOutputImpl(@NotNull T resource, long min, long max, float probability, IngredientType<T> type, @Nullable class_2487 nbt) {
        this.resource = resource;
        this.type = type;
        this.lootFunction = class_6019.method_35017((int)((int)min), (int)((int)max));
        this.random = class_5819.method_43047();
        this.chance = probability;
        this.nbt = nbt == null || nbt.method_33133() ? null : nbt;
    }

    public RecipeOutputImpl(@NotNull T resource, long amount, float probability, IngredientType<T> type, class_2487 nbt) {
        this(resource, amount, amount, probability, type, nbt);
    }

    public static <R> Codec<RecipeOutput<R>> makeCodec(IngredientType<R> type) {
        MapCodec resourceCodec = type.resourceCodec().fieldOf("resource");
        MapCodec chanceCodec = Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f));
        MapCodec amountCodec = Codec.LONG.fieldOf("amount");
        MapCodec minCodec = Codec.LONG.fieldOf("min");
        MapCodec maxCodec = Codec.LONG.fieldOf("max");
        MapCodec nbtCodec = class_2487.field_25128.optionalFieldOf("data", (Object)new class_2487());
        Codec justAmount = RecordCodecBuilder.create(instance -> instance.group((App)resourceCodec.forGetter(RecipeOutputImpl::resource), (App)chanceCodec.forGetter(RecipeOutputImpl::chance), (App)amountCodec.forGetter(RecipeOutputImpl::maxAmount), (App)nbtCodec.forGetter(RecipeOutputImpl::getNbt)).apply((Applicative)instance, (resource, chance, amount, nbt) -> new RecipeOutputImpl<Object>(resource, (long)amount, chance.floatValue(), type, (class_2487)nbt)));
        Codec minMax = RecordCodecBuilder.create(instance -> instance.group((App)resourceCodec.forGetter(RecipeOutputImpl::resource), (App)chanceCodec.forGetter(RecipeOutputImpl::chance), (App)minCodec.forGetter(RecipeOutputImpl::minAmount), (App)maxCodec.forGetter(RecipeOutputImpl::maxAmount), (App)nbtCodec.forGetter(RecipeOutputImpl::getNbt)).apply((Applicative)instance, (resource, chance, min, max, nbt) -> new RecipeOutputImpl<Object>(resource, (long)min, (long)max, chance.floatValue(), type, (class_2487)nbt)));
        return Codec.either((Codec)justAmount, (Codec)minMax).xmap(MeatLibCodecs::collapseEither, Either::right).xmap(Function.identity(), o -> (RecipeOutputImpl)o);
    }

    public static <R> RecipeOutput<R> fromJson(JsonObject json) {
        if (json.has("type")) {
            class_2960 typeId = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
            IngredientType<?> type = IngredientType.ALL_TYPES.get(typeId);
            return RecipeOutputImpl.fromJson(type, json);
        }
        throw new JsonParseException("Recipe input does not specify resource type.");
    }

    public static <R> RecipeOutput<R> fromJson(IngredientType<R> type, JsonObject json) {
        return (RecipeOutput)((Pair)RecipeOutputImpl.makeCodec(type).decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)MeatLib.LOGGER).error(arg_0))).getFirst();
    }

    public static <R> List<RecipeOutput<R>> fromJsonArray(IngredientType<R> type, JsonArray array) {
        ObjectArrayList list = new ObjectArrayList();
        for (JsonElement element : array) {
            JsonObject object = (JsonObject)element;
            list.add(RecipeOutputImpl.fromJson(type, object));
        }
        return list;
    }

    public static <R> RecipeOutputImpl<R> read(class_2378<R> registry, class_2540 buf) {
        IngredientType type = IngredientType.read(buf);
        class_2960 id = buf.method_10810();
        Object resource = registry.method_10223(id);
        int min = buf.method_10816();
        int max = buf.method_10816();
        float chance = buf.readFloat();
        class_2487 nbt = buf.method_10798();
        return new RecipeOutputImpl<Object>(resource, min, max, chance, type, nbt);
    }

    public static <R> void writeList(class_2378<R> registry, List<RecipeOutput<R>> list, class_2540 buf) {
        buf.method_10804(list.size());
        for (RecipeOutput<R> element : list) {
            element.write(buf);
        }
    }

    public static <R> List<RecipeOutput<R>> readList(class_2378<R> registry, class_2540 buf) {
        ObjectArrayList list = new ObjectArrayList();
        int size = buf.method_10816();
        for (int i = 0; i < size; ++i) {
            list.add(RecipeOutputImpl.read(registry, buf));
        }
        return list;
    }

    @Override
    public T resource() {
        return this.resource;
    }

    @Override
    public long randomAmount(float chanceMod) {
        float newChance = this.chance + chanceMod;
        int rolls = class_3532.method_15375((float)newChance);
        float bonus = newChance % 1.0f;
        long amount = 0L;
        for (int roll = 0; roll < rolls; ++roll) {
            amount += (long)this.lootFunction.method_35008(this.random);
        }
        if (bonus > 0.0f && this.random.method_43057() < bonus) {
            amount += (long)this.lootFunction.method_35008(this.random);
        }
        return amount;
    }

    @Override
    public long maxAmount() {
        return this.lootFunction.method_35011();
    }

    @Override
    public long minAmount() {
        return this.lootFunction.method_35009();
    }

    @Override
    public float chance() {
        return this.chance;
    }

    @Override
    @Nullable
    public class_2487 getNbt() {
        return this.nbt;
    }

    @Override
    public IngredientType<T> getType() {
        return this.type;
    }

    @Override
    public <V extends TransferVariant<T>> boolean insertInto(Storage<V> storage, BiFunction<T, class_2487, V> of, float chanceModifier, TransactionContext transaction) {
        long amount = this.randomAmount(chanceModifier);
        if (amount == 0L) {
            return true;
        }
        TransferVariant variant = (TransferVariant)of.apply(this.resource, this.nbt);
        long inserted = storage.insert((Object)variant, amount, transaction);
        return inserted == amount;
    }

    @Override
    public void write(class_2540 buf) {
        this.type.write(buf);
        buf.method_10812(this.type.getIdFor(this.resource));
        buf.method_10804(this.lootFunction.method_35009());
        buf.method_10804(this.lootFunction.method_35011());
        buf.writeFloat(this.chance);
        buf.method_10794(this.nbt);
    }
}

