/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.network;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3532;

public final class PacketBufUtil {
    public static byte packAngle(float angle) {
        return (byte)class_3532.method_15375((float)(angle * 256.0f / 360.0f));
    }

    public static float unpackAngle(byte angleByte) {
        return (float)(angleByte * 360) / 256.0f;
    }

    public static void writeAngle(class_2540 buf, float angle) {
        buf.writeByte((int)PacketBufUtil.packAngle(angle));
    }

    public static float readAngle(class_2540 buf) {
        return PacketBufUtil.unpackAngle(buf.readByte());
    }

    public static void writeVec3d(class_2540 buf, class_243 vec3d) {
        buf.writeDouble(vec3d.field_1352);
        buf.writeDouble(vec3d.field_1351);
        buf.writeDouble(vec3d.field_1350);
    }

    public static class_243 readVec3d(class_2540 buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new class_243(x, y, z);
    }

    public static void writeBlockPos(class_2540 buf, class_2338 pos) {
        buf.method_10804(pos.method_10263());
        buf.method_10804(pos.method_10264());
        buf.method_10804(pos.method_10260());
    }

    public static class_2338 readBlockPos(class_2540 buf) {
        return new class_2338(buf.method_10816(), buf.method_10816(), buf.method_10816());
    }

    public static <K, V> void writeMap(class_2540 buf, Map<K, V> map, BiConsumer<K, class_2540> writeKey, BiConsumer<V, class_2540> writeVal) {
        buf.method_10804(map.size());
        map.forEach((key, val) -> {
            writeKey.accept(key, buf);
            writeVal.accept(val, buf);
        });
    }

    public static <K, V> void readMap(class_2540 buf, BiConsumer<K, V> add, Function<class_2540, K> readKey, Function<class_2540, V> readVal) {
        int size = buf.method_10816();
        for (int i = 0; i < size; ++i) {
            K key = readKey.apply(buf);
            V val = readVal.apply(buf);
            add.accept(key, val);
        }
    }

    public static <T> void writeList(class_2540 buf, List<T> list, BiConsumer<class_2540, T> writer) {
        buf.method_10804(list.size());
        for (T element : list) {
            writer.accept(buf, (class_2540)element);
        }
    }

    public static <T> List<T> readList(class_2540 buf, Function<class_2540, T> reader) {
        int size = buf.method_10816();
        return IntStream.range(0, size).mapToObj(i -> reader.apply(buf)).toList();
    }
}

