/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.network;

import com.neep.meatlib.MeatLib;
import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.client.ClientChannelSender;
import com.neep.meatlib.client.GlobalClientChannelReceiver;
import com.neep.meatlib.network.GlobalServerChannelReceiver;
import com.neep.meatlib.network.Sender;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class GlobalChannelManager<T> {
    private final class_2960 name;
    private final ChannelFormat<T> format;

    public static <T> GlobalChannelManager<T> create(class_2960 name, ChannelFormat<T> format) {
        return new GlobalChannelManager<T>(name, format);
    }

    protected GlobalChannelManager(class_2960 name, ChannelFormat<T> format) {
        this.name = name;
        this.format = format;
    }

    private Sender<T> createSender(@Nullable class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            return buf -> ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)this.name, (class_2540)buf);
        }
        return new ClientChannelSender<T>(this.name, this.format);
    }

    public ChannelFormat<T> format() {
        return this.format;
    }

    public T emitter(@Nullable class_1657 to) {
        return this.format.emitter(this.createSender(to));
    }

    public void receiver(EnvType envType, T listener) {
        if (envType == EnvType.SERVER && !MeatLib.isClient()) {
            GlobalServerChannelReceiver.register(this.name, this.format, listener);
        } else if (MeatLib.isClient()) {
            GlobalClientChannelReceiver.register(this.name, this.format, listener);
        }
    }

    public void receiverHandler(EnvType envType, ReceiveHandler<T> handler) {
        if (envType == EnvType.SERVER) {
            GlobalServerChannelReceiver.register(this.name, this.format, handler);
        } else {
            GlobalClientChannelReceiver.register(this.name, this.format, handler);
        }
    }

    public static interface ReceiveHandler<T> {
        public T receive(class_1657 var1, class_2540 var2, PacketSender var3);
    }
}

