/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.network;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.client.ClientChannelReceiver;
import com.neep.meatlib.client.ClientChannelSender;
import com.neep.meatlib.network.Receiver;
import com.neep.meatlib.network.Sender;
import com.neep.meatlib.network.ServerChannelReceiver;
import com.neep.meatlib.network.ServerChannelSender;
import com.neep.meatlib.screen.Closable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ChannelManager<T>
implements Closable {
    private final class_2960 name;
    private final ChannelFormat<T> format;
    private final class_1657 player;
    private final List<Receiver<T>> receivers = new ArrayList<Receiver<T>>();
    private final Sender<T> sender;
    @Nullable
    private T emitter;

    public static <T> ChannelManager<T> create(class_2960 name, ChannelFormat<T> format, class_1657 player) {
        return new ChannelManager<T>(name, format, player);
    }

    protected ChannelManager(class_2960 name, ChannelFormat<T> format, class_1657 player) {
        this.name = name;
        this.format = format;
        this.player = player;
        this.sender = this.createSender(player);
    }

    private Sender<T> createSender(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            return new ServerChannelSender<T>(this.name, this.format, (class_1657)serverPlayerEntity);
        }
        return new ClientChannelSender<T>(this.name, this.format);
    }

    public ChannelFormat<T> format() {
        return this.format;
    }

    public T emitter() {
        if (this.emitter == null) {
            this.emitter = this.format.emitter(this.sender);
        }
        return this.emitter;
    }

    public void receiver(T listener) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerChannelReceiver<T> receiver = new ServerChannelReceiver<T>(serverPlayer.field_13987, this.name, this.format, listener);
            this.receivers.add(receiver);
        } else {
            ClientChannelReceiver<T> receiver = new ClientChannelReceiver<T>(this.name, this.format, listener);
            this.receivers.add(receiver);
        }
    }

    @Override
    public void close() {
        this.receivers.forEach(Receiver::close);
    }
}

