/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.larkdown;

import com.neep.meatlib.larkdown.LarkdownContent;
import com.neep.meatlib.larkdown.LarkdownParseException;
import com.neep.meatlib.larkdown.LarkdownParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;

public class LarkdownParserTest {
    public static void main(String[] args) {
        String markdown = "---\nid: the_thingy\n---\n# Heading 1\n## Heading 2\n\n### Heading 3\n\n**Some bold text**\n\nsome `code` here\n\n\\image[width=32,height=98,scale=0.2]{neepmeat:guide/images/transducer_usage.png}\nThe text begins! **Some bold* text** and a little bit of *italic* text NOW IS THE END OF THE TEXT.\n";
        StringReader reader = new StringReader(markdown);
        LarkdownParser parser = new LarkdownParser(reader);
        try {
            List<LarkdownContent> contents = parser.getContents();
            Map<String, String> preamble = parser.getPreamble();
            for (LarkdownContent content : contents) {
                System.out.println(content);
            }
            System.out.println();
            System.out.println(preamble);
        }
        catch (LarkdownParseException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

